% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translate_axes.R
\name{translate_axes}
\alias{translate_axes}
\title{Translate biplot axes}
\usage{
translate_axes(bp, delta = 0, swop = FALSE, distances = NULL)
}
\arguments{
\item{bp}{An object of class \code{biplot}}

\item{delta}{numeric value indicating distance between axes}

\item{swop}{logical. Change the direction in which axes are translated}

\item{distances}{numeric vector of distances. Used to manually parallel translate the axes.}
}
\value{
An object of class \code{biplot} with the translated distances appended under bp$axes
}
\description{
Automatically or manually translate the axes away from the center of the plot
}
\details{
This function uses the same algorithm implemented in \code{\link[bipl5]{TDAbiplot}}
in the \code{bipl5} package. It translates the axes out of the center of the plot.
Correlated axes generally gets translated in the same direction.

This function calculates the \code{orthogx} and \code{orthogy} paramaters in \code{\link[=axes]{axes()}}
}
\examples{

#Translate the axes out of the plot center

bp <- biplot(state.x77,scaled = TRUE)|> 
      CVA(state.region) |> 
      translate_axes(swop=TRUE,delta =0.2)|>
      plot(exp.factor=3)

#adjust the distance of an axis

dist <- bp$axes$translate_distance
dist[7] <- 0.4
bp |> translate_axes(delta = 0.2, distances=dist) |> plot()
}
