% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/birp.R
\name{plot.birp}
\alias{plot.birp}
\title{Plot posterior distributions of gamma parameters}
\usage{
\method{plot}{birp}(
  x,
  shadingIncrease = NA,
  shadingDecrease = "#f2c7c7",
  col = "black",
  lwd = 1,
  lty = 1:x$num_gamma,
  xlim = NA,
  ylim = NA,
  add = FALSE,
  xlab = expression(gamma),
  ylab = "Posterior density",
  legend = x$gamma_names,
  lineAtZero = TRUE,
  ...
)
}
\arguments{
\item{x}{A \code{birp} object.}

\item{shadingIncrease}{Character or color specification; Shading color for the range where the gamma parameter is greater than 0 (\code{gamma > 0}). If \code{NA}, shading is omitted. Default is \code{NA}.}

\item{shadingDecrease}{Character or color specification; Shading color for the range where the gamma parameter is less than 0 (\code{gamma < 0}). If \code{NA}, shading is omitted. Default is \code{"#f2c7c7"}.}

\item{col}{Character vector or color values; Line color(s) for the density plots. If a single value is provided, it is recycled for all gamma parameters. Default is \code{"black"}.}

\item{lwd}{Numeric vector; Line width(s) for the density plots. If a single value is provided, it is recycled. Default is 1.}

\item{lty}{Numeric or character vector; Line type(s) for the density plots. If a single value is provided, it is recycled. Default is \code{1:x$num_gamma}.}

\item{xlim}{Numeric vector of length 2; Optional x-axis limits. If \code{NA}, limits are determined automatically from the density data. Default is \code{NA}.}

\item{ylim}{Numeric vector of length 2; Optional y-axis limits. If \code{NA}, limits are determined automatically from the density data. Default is \code{NA}.}

\item{add}{Logical; If \code{TRUE}, adds the densities to an existing plot. Otherwise, creates a new plot. Default is \code{FALSE}.}

\item{xlab}{Character; Label for the x-axis. Default is \code{expression(gamma)}.}

\item{ylab}{Character; Label for the y-axis. Default is \code{"Posterior density"}.}

\item{legend}{Character vector of legend labels, or \code{NA} to suppress the legend. Default is \code{x$gamma_names}.}

\item{lineAtZero}{Logical; If \code{TRUE}, adds a vertical line at x = 0 to indicate no effect. Default is \code{TRUE}.}

\item{...}{Additional graphical parameters passed to \code{\link[graphics]{lines}} (when plotting the densities) and \code{\link[graphics]{plot}} (when creating a new plot).}
}
\value{
No return value, called for side effects.
}
\description{
Plots the posterior densities of the gamma parameters estimated by a \code{birp} object.
}
\examples{
data <- simulate_birp()
est <- birp(data)
plot(est)
}
\seealso{
\code{\link{birp}}
}
