% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waic.R
\name{waic.cumhist}
\alias{waic.cumhist}
\title{Computes widely applicable information criterion
(WAIC).}
\usage{
\method{waic}{cumhist}(x, ...)
}
\arguments{
\item{x}{A \link[=cumhist-class]{cumhist} object.}

\item{...}{Additional arguments (unused)}
}
\value{
A named list, see \code{\link[loo:waic]{loo::waic()}} for details.
}
\description{
Computes widely applicable information criterion
via \link[=loo-package]{loo} library. It can be used for a model comparison via
\link[loo:loo_compare]{loo::loo_compare()} function.
}
\examples{
 \donttest{
data(br_singleblock)
gamma_fit <- fit_cumhist(br_singleblock, state="State", duration="Duration")
waic_gamma <- waic(gamma_fit)
normal_fit <- fit_cumhist(br_singleblock, state="State", duration="Duration", family="normal")
waic_normal <- waic(normal_fit)
loo::loo_compare(waic_gamma, waic_normal)
}
}
