% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_post_beast.R
\name{plot_post_beast}
\alias{plot_post_beast}
\title{Plot posterior probabilities from beast}
\usage{
plot_post_beast(mcc, post = TRUE, post.var = "rate",
  post.cex = par("cex"), post.col = "#ee964b", post.alpha = 1,
  post.border = "#000000", post.lwd = par("lwd"), leg = TRUE,
  leg.frac = c(0.2, 0.5), leg.lab = "rate", leg.cex = par("cex")/2,
  sup = TRUE, sup.var = "posterior", sup.cex = par("cex")/2,
  bars = FALSE, bar.var = "height_95\%_HPD", bar.col = "#2e86ab",
  bar.alpha = 0.8, bar.thc = par("cex")/10, bar.border = "#000000",
  bar.lwd = par("lwd"), ...)
}
\arguments{
\item{mcc}{A character containing the path to the Maximum credibility tree from the Beast analysis and extracted from treeAnnotator}

\item{post}{A logical specifying whether the mean posterior value of a parameter should be plot along the tree}

\item{post.var}{A character containing the name of the parameter (only evaluated if post == TRUE)}

\item{post.cex}{A numeric giving the size of the dots (only evaluated if post == TRUE)}

\item{post.col}{Color of the dots (only evaluated if post == TRUE)}

\item{post.alpha}{A numeric giving the transparency of the dots (only evaluated if post == TRUE)}

\item{post.border}{Color of the dots' border (only evaluated if post == TRUE)}

\item{post.lwd}{Line width of the dots' border (only evaluated if post == TRUE)}

\item{leg}{A logical specifying whether a legend should be plotted (only evaluated if post == TRUE)}

\item{leg.frac}{A vector giving the proportion of the plot window taken by the legend (only evaluated if post == TRUE)}

\item{leg.lab}{Label of the legend (only evaluated if post == TRUE)}

\item{leg.cex}{A numeric giving the size of the legend (only evaluated if post == TRUE)}

\item{sup}{A logical specifying whether node support information should be displayed}

\item{sup.var}{A character containing the name of the support variable (only evaluated if sup == TRUE)}

\item{sup.cex}{A numeric giving the size of node support information (only evaluated if sup == TRUE)}

\item{bars}{A logical specifying whether node age bars should be plotted}

\item{bar.var}{A character containing the name of the node age variable. MIN and MAX should be available for this variable (only evaluated if bars == TRUE)}

\item{bar.col}{Color of the bars (only evaluated if bars == TRUE)}

\item{bar.alpha}{A numeric giving the transparency of the bars (only evaluated if bars == TRUE)}

\item{bar.thc}{A numeric giving the thickness of the bars (only evaluated if bars == TRUE)}

\item{bar.border}{Color of the bars' border (only evaluated if bars == TRUE)}

\item{bar.lwd}{Line width of the bars' border (only evaluated if bars == TRUE)}

\item{...}{additional parameters that can be parsed to \code{\link[ape]{plot.phylo}}}
}
\value{
plot
}
\description{
This function plots the phylogenetic tree along with mean posterior probabilities of the chosen parameter. 
The default plots paramenter value under multiple regimes estimated with the beast implementation of JIVE, OU, BM and WN.
Options are included to plot node support and age bars.
}
\details{
leg = TRUE changes the proportion of the plot.window taken by the plot. Use \code{par(fig = c(0,1,0,1))} to restore default parameters
}
\author{
Theo Gaboriau
}
