% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bizdiff.R
\name{bizdiff}
\alias{bizdiff}
\title{Compute the amount of business days between dates}
\usage{
bizdiff(dates, cal)
}
\arguments{
\item{dates}{a vector containing the dates to be differenced}

\item{cal}{the calendar's name}
}
\value{
A `numeric` vector of length `n-1` (where `n` is the input vector length),
containing the business days computed between pairs of dates.
}
\description{
Returns the number of business days between dates in a given vector of dates.
}
\section{Date types accepted}{


The arguments \code{from} and \code{to} accept \code{Date} objects and any
object that returns a valid \code{Date} object when passed through
\code{as.Date}, which include all \code{POSIX*} classes and \code{character}
objects with ISO formatted dates.
}

\examples{
dates <- c("2017-05-10", "2017-05-12", "2017-05-17")
bizdiff(dates, "Brazil/ANBIMA")
}
