% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar-export.R
\name{calendar-import-export}
\alias{calendar-import-export}
\alias{save_calendar}
\alias{load_calendar}
\title{Import and export calendars}
\usage{
save_calendar(cal, con)

load_calendar(con)
}
\arguments{
\item{cal}{the calendar's name}

\item{con}{a connection object or a character string.}
}
\description{
The calendars can be specified in JSON files and these functions helps with
importing and exporting calendars to text files.
}
\details{
\code{save_calendar} exports a calendar to a JSON file and
\code{load_calendar} imports.

In \code{load_calenadar}, the \code{con} argument can be a connection object
or a character string specifying either the file or the JSON text.
}
\section{JSON calendar's specification}{


Here's an example of a calendar's specification.

\preformatted{
  {
   "name": "Brazil/ANBIMA",
   "weekdays": ["saturday", "sunday"],
   "holidays": ["2001-01-01", "2001-02-26", "2001-02-27", "2001-04-13"],
   "adjust.from": "following",
   "adjust.to": "preceding"
   "financial": true,
  }
}
}

\examples{
con <- tempfile(fileext = ".json")
save_calendar("actual", con)
load_calendar(con)
}
