% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulate_Data.R
\name{choose_beta}
\alias{choose_beta}
\title{choose_beta}
\usage{
choose_beta(param)
}
\arguments{
\item{param}{a list containing:
\describe{
 \item{grid}{a numerical vector, the time points.}
 \item{p}{a numerical value, the length of the vector \code{grid}.}
 \item{shape}{a character vector: "smooth", "random_smooth",
              "simple", "simple_bis", "random_simple", "sinusoid",
              "flat_sinusoid" and "sharp"}
}}
}
\value{
A numerical vector which corresponds to the coefficient function
        at given times points (\code{grid}).
}
\description{
Compute a coefficient function for the Function Linear Regression
             model.
}
\details{
Several shapes are available.
}
\examples{
### smooth
param <- list(p=100,grid=seq(0,1,length=100),shape="smooth")
beta_function <- choose_beta(param)
plot(param$grid,beta_function,type="l")
### random_smooth
param <- list(p=100,grid=seq(0,1,length=100),shape="random_smooth")
beta_function <- choose_beta(param)
plot(param$grid,beta_function,type="l")
### simple
param <- list(p=100,grid=seq(0,1,length=100),shape="simple")
beta_function <- choose_beta(param)
plot(param$grid,beta_function,type="s")
### simple_bis
param <- list(p=100,grid=seq(0,1,length=100),shape="simple_bis")
beta_function <- choose_beta(param)
plot(param$grid,beta_function,type="s")
### random_simple
param <- list(p=100,grid=seq(0,1,length=100),shape="random_simple")
beta_function <- choose_beta(param)
plot(param$grid,beta_function,type="s")
### sinusoid
param <- list(p=100,grid=seq(0,1,length=100),shape="sinusoid")
beta_function <- choose_beta(param)
plot(param$grid,beta_function,type="l")
### flat_sinusoid
param <- list(p=100,grid=seq(0,1,length=100),shape="flat_sinusoid")
beta_function <- choose_beta(param)
plot(param$grid,beta_function,type="l")
### sharp
param <- list(p=100,grid=seq(0,1,length=100),shape="sharp")
beta_function <- choose_beta(param)
plot(param$grid,beta_function,type="l")
}
