% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blr-bivariate-analysis.R
\name{blr_bivariate_analysis}
\alias{blr_bivariate_analysis}
\alias{blr_bivariate_analysis.default}
\title{Bivariate analysis}
\usage{
blr_bivariate_analysis(data, response, ...)

\method{blr_bivariate_analysis}{default}(data, response, ...)
}
\arguments{
\item{data}{A \code{tibble} or a \code{data.frame}.}

\item{response}{Response variable; column in \code{data}.}

\item{...}{Predictor variables; columns in \code{data}.}
}
\value{
A tibble with the following columns:
\item{Variable}{Variable name}
\item{Information Value}{Information value}
\item{LR Chi Square}{Likelihood ratio statisitc}
\item{LR DF}{Likelihood ratio degrees of freedom}
\item{LR p-value}{Likelihood ratio p value}
}
\description{
Information value and likelihood ratio chi square test for initial
  variable/predictor selection. Currently avialable for categorical
  predictors only.
}
\examples{
blr_bivariate_analysis(hsb2, honcomp, female, prog, race, schtyp)

}
\seealso{
Other bivariate analysis procedures: 
\code{\link{blr_segment_dist}()},
\code{\link{blr_segment_twoway}()},
\code{\link{blr_segment}()},
\code{\link{blr_woe_iv_stats}()},
\code{\link{blr_woe_iv}()}
}
\concept{bivariate analysis procedures}
