// Generated by rstantools.  Do not edit by hand.

/*
    bmgarch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    bmgarch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with bmgarch.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_CCCMGARCH_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_CCCMGARCH");
    reader.add_event(2, 2, "include", "/functions/cov2cor.stan");
    reader.add_event(2, 0, "start", "/functions/cov2cor.stan");
    reader.add_event(10, 8, "end", "/functions/cov2cor.stan");
    reader.add_event(10, 3, "restart", "model_CCCMGARCH");
    reader.add_event(10, 3, "include", "/functions/jacobian.stan");
    reader.add_event(10, 0, "start", "/functions/jacobian.stan");
    reader.add_event(89, 79, "end", "/functions/jacobian.stan");
    reader.add_event(89, 4, "restart", "model_CCCMGARCH");
    reader.add_event(91, 6, "include", "/data/data.stan");
    reader.add_event(91, 0, "start", "/data/data.stan");
    reader.add_event(99, 8, "end", "/data/data.stan");
    reader.add_event(99, 7, "restart", "model_CCCMGARCH");
    reader.add_event(105, 13, "include", "/transformed_data/xh_marker.stan");
    reader.add_event(105, 0, "start", "/transformed_data/xh_marker.stan");
    reader.add_event(117, 12, "end", "/transformed_data/xh_marker.stan");
    reader.add_event(117, 14, "restart", "model_CCCMGARCH");
    reader.add_event(133, 30, "include", "/parameters/arma.stan");
    reader.add_event(133, 0, "start", "/parameters/arma.stan");
    reader.add_event(140, 7, "end", "/parameters/arma.stan");
    reader.add_event(140, 31, "restart", "model_CCCMGARCH");
    reader.add_event(141, 32, "include", "/parameters/predH.stan");
    reader.add_event(141, 0, "start", "/parameters/predH.stan");
    reader.add_event(145, 4, "end", "/parameters/predH.stan");
    reader.add_event(145, 33, "restart", "model_CCCMGARCH");
    reader.add_event(187, 75, "include", "/model_components/mu.stan");
    reader.add_event(187, 0, "start", "/model_components/mu.stan");
    reader.add_event(197, 10, "end", "/model_components/mu.stan");
    reader.add_event(197, 76, "restart", "model_CCCMGARCH");
    reader.add_event(257, 136, "include", "/generated/retrodict_H.stan");
    reader.add_event(257, 0, "start", "/generated/retrodict_H.stan");
    reader.add_event(271, 14, "end", "/generated/retrodict_H.stan");
    reader.add_event(271, 137, "restart", "model_CCCMGARCH");
    reader.add_event(275, 139, "end", "model_CCCMGARCH");
    return reader;
}
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, Eigen::Dynamic>
cov2cor(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& C, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 4;
        int dm(0);
        (void) dm;  // dummy to suppress unused var warning
        stan::math::fill(dm, std::numeric_limits<int>::min());
        stan::math::assign(dm,rows(C));
        current_statement_begin__ = 5;
        validate_non_negative_index("s", "dm", dm);
        validate_non_negative_index("s", "dm", dm);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> s(dm, dm);
        stan::math::initialize(s, DUMMY_VAR__);
        stan::math::fill(s, DUMMY_VAR__);
        current_statement_begin__ = 6;
        validate_non_negative_index("R", "dm", dm);
        validate_non_negative_index("R", "dm", dm);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> R(dm, dm);
        stan::math::initialize(R, DUMMY_VAR__);
        stan::math::fill(R, DUMMY_VAR__);
        current_statement_begin__ = 7;
        stan::math::assign(s, diag_matrix(elt_divide(1.0, stan::math::sqrt(diagonal(C)))));
        current_statement_begin__ = 8;
        stan::math::assign(R, multiply(multiply(s, C), s));
        current_statement_begin__ = 9;
        return stan::math::promote_scalar<fun_return_scalar_t__>(R);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct cov2cor_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& C, std::ostream* pstream__) const {
        return cov2cor(C, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__>
typename boost::math::tools::promote_args<T0__, T1__, T2__>::type
a_b_scale_jacobian(const T0__& a,
                       const T1__& b,
                       const T2__& value, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 19;
        local_scalar_t__ invlogit_value(DUMMY_VAR__);
        (void) invlogit_value;  // dummy to suppress unused var warning
        stan::math::initialize(invlogit_value, DUMMY_VAR__);
        stan::math::fill(invlogit_value, DUMMY_VAR__);
        stan::math::assign(invlogit_value,inv_logit(value));
        current_statement_begin__ = 20;
        local_scalar_t__ out(DUMMY_VAR__);
        (void) out;  // dummy to suppress unused var warning
        stan::math::initialize(out, DUMMY_VAR__);
        stan::math::fill(out, DUMMY_VAR__);
        stan::math::assign(out,((stan::math::log((b - a)) + stan::math::log(invlogit_value)) + log1m(invlogit_value)));
        current_statement_begin__ = 21;
        return stan::math::promote_scalar<fun_return_scalar_t__>(out);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct a_b_scale_jacobian_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__>::type
    operator()(const T0__& a,
                       const T1__& b,
                       const T2__& value, std::ostream* pstream__) const {
        return a_b_scale_jacobian(a, b, value, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__>
typename boost::math::tools::promote_args<T0__, T1__, T2__>::type
a_b_scale(const T0__& a,
              const T1__& b,
              const T2__& value, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        current_statement_begin__ = 32;
        return stan::math::promote_scalar<fun_return_scalar_t__>((a + ((b - a) * inv_logit(value))));
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct a_b_scale_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__>::type
    operator()(const T0__& a,
              const T1__& b,
              const T2__& value, std::ostream* pstream__) const {
        return a_b_scale(a, b, value, pstream__);
    }
};
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
upper_limits(const std::vector<Eigen::Matrix<T0__, Eigen::Dynamic, 1> >& a_h, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 42;
        int nt(0);
        (void) nt;  // dummy to suppress unused var warning
        stan::math::fill(nt, std::numeric_limits<int>::min());
        stan::math::assign(nt,num_elements(get_base1(a_h, 1, "a_h", 1)));
        current_statement_begin__ = 43;
        int Q(0);
        (void) Q;  // dummy to suppress unused var warning
        stan::math::fill(Q, std::numeric_limits<int>::min());
        stan::math::assign(Q,size(a_h));
        current_statement_begin__ = 44;
        validate_non_negative_index("a_h_sums", "nt", nt);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> a_h_sums(nt);
        stan::math::initialize(a_h_sums, DUMMY_VAR__);
        stan::math::fill(a_h_sums, DUMMY_VAR__);
        current_statement_begin__ = 45;
        validate_non_negative_index("out", "nt", nt);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> out(nt);
        stan::math::initialize(out, DUMMY_VAR__);
        stan::math::fill(out, DUMMY_VAR__);
        current_statement_begin__ = 46;
        for (int k = 1; k <= nt; ++k) {
            current_statement_begin__ = 47;
            stan::model::assign(a_h_sums, 
                        stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                        sum(stan::model::rvalue(a_h, stan::model::cons_list(stan::model::index_min_max(1, Q), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), "a_h")), 
                        "assigning variable a_h_sums");
            current_statement_begin__ = 48;
            stan::model::assign(out, 
                        stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                        (1 - get_base1(a_h_sums, k, "a_h_sums", 1)), 
                        "assigning variable out");
            current_statement_begin__ = 49;
            if (as_bool(logical_lte(get_base1(out, k, "out", 1), 0))) {
                current_statement_begin__ = 49;
                stan::model::assign(out, 
                            stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                            .00001, 
                            "assigning variable out");
            }
        }
        current_statement_begin__ = 52;
        return stan::math::promote_scalar<fun_return_scalar_t__>(out);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct upper_limits_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
    operator()(const std::vector<Eigen::Matrix<T0__, Eigen::Dynamic, 1> >& a_h, std::ostream* pstream__) const {
        return upper_limits(a_h, pstream__);
    }
};
template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
raw_sum_to_b_h_sum(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& b_h_sum_s,
                       const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& upperLimits, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 62;
        int nt(0);
        (void) nt;  // dummy to suppress unused var warning
        stan::math::fill(nt, std::numeric_limits<int>::min());
        stan::math::assign(nt,num_elements(upperLimits));
        current_statement_begin__ = 63;
        validate_non_negative_index("out", "nt", nt);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> out(nt);
        stan::math::initialize(out, DUMMY_VAR__);
        stan::math::fill(out, DUMMY_VAR__);
        current_statement_begin__ = 64;
        for (int k = 1; k <= nt; ++k) {
            current_statement_begin__ = 65;
            stan::model::assign(out, 
                        stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                        a_b_scale(0, get_base1(upperLimits, k, "upperLimits", 1), get_base1(b_h_sum_s, k, "b_h_sum_s", 1), pstream__), 
                        "assigning variable out");
        }
        current_statement_begin__ = 67;
        return stan::math::promote_scalar<fun_return_scalar_t__>(out);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct raw_sum_to_b_h_sum_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& b_h_sum_s,
                       const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& upperLimits, std::ostream* pstream__) const {
        return raw_sum_to_b_h_sum(b_h_sum_s, upperLimits, pstream__);
    }
};
template <typename T0__, typename T1__>
std::vector<Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1> >
simplex_to_bh(const std::vector<Eigen::Matrix<T0__, Eigen::Dynamic, 1> >& b_h_simplex,
                  const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& b_h_sum, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 82;
        int nt(0);
        (void) nt;  // dummy to suppress unused var warning
        stan::math::fill(nt, std::numeric_limits<int>::min());
        stan::math::assign(nt,size(b_h_simplex));
        current_statement_begin__ = 83;
        int P(0);
        (void) P;  // dummy to suppress unused var warning
        stan::math::fill(P, std::numeric_limits<int>::min());
        stan::math::assign(P,num_elements(get_base1(b_h_simplex, 1, "b_h_simplex", 1)));
        current_statement_begin__ = 84;
        validate_non_negative_index("b_h", "nt", nt);
        validate_non_negative_index("b_h", "P", P);
        std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>  > b_h(P, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>(nt));
        stan::math::initialize(b_h, DUMMY_VAR__);
        stan::math::fill(b_h, DUMMY_VAR__);
        current_statement_begin__ = 85;
        for (int k = 1; k <= nt; ++k) {
            current_statement_begin__ = 86;
            stan::model::assign(b_h, 
                        stan::model::cons_list(stan::model::index_min_max(1, P), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), 
                        to_array_1d(multiply(get_base1(b_h_simplex, k, "b_h_simplex", 1), get_base1(b_h_sum, k, "b_h_sum", 1))), 
                        "assigning variable b_h");
        }
        current_statement_begin__ = 88;
        return stan::math::promote_scalar<fun_return_scalar_t__>(b_h);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct simplex_to_bh_functor__ {
    template <typename T0__, typename T1__>
        std::vector<Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1> >
    operator()(const std::vector<Eigen::Matrix<T0__, Eigen::Dynamic, 1> >& b_h_simplex,
                  const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& b_h_sum, std::ostream* pstream__) const {
        return simplex_to_bh(b_h_simplex, b_h_sum, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_CCCMGARCH
  : public stan::model::model_base_crtp<model_CCCMGARCH> {
private:
        int T;
        int nt;
        int Q;
        int P;
        std::vector<vector_d> rts;
        std::vector<vector_d> xC;
        int distribution;
        int meanstructure;
        vector_d rts_m;
        vector_d rts_sd;
        std::vector<matrix_d> xC_m;
        int xC_marker;
        double cp;
public:
    model_CCCMGARCH(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_CCCMGARCH(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_CCCMGARCH_namespace::model_CCCMGARCH";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 92;
            context__.validate_dims("data initialization", "T", "int", context__.to_vec());
            T = int(0);
            vals_i__ = context__.vals_i("T");
            pos__ = 0;
            T = vals_i__[pos__++];
            check_greater_or_equal(function__, "T", T, 2);
            current_statement_begin__ = 93;
            context__.validate_dims("data initialization", "nt", "int", context__.to_vec());
            nt = int(0);
            vals_i__ = context__.vals_i("nt");
            pos__ = 0;
            nt = vals_i__[pos__++];
            check_greater_or_equal(function__, "nt", nt, 2);
            current_statement_begin__ = 94;
            context__.validate_dims("data initialization", "Q", "int", context__.to_vec());
            Q = int(0);
            vals_i__ = context__.vals_i("Q");
            pos__ = 0;
            Q = vals_i__[pos__++];
            check_greater_or_equal(function__, "Q", Q, 1);
            current_statement_begin__ = 95;
            context__.validate_dims("data initialization", "P", "int", context__.to_vec());
            P = int(0);
            vals_i__ = context__.vals_i("P");
            pos__ = 0;
            P = vals_i__[pos__++];
            check_greater_or_equal(function__, "P", P, 1);
            current_statement_begin__ = 96;
            validate_non_negative_index("rts", "nt", nt);
            validate_non_negative_index("rts", "T", T);
            context__.validate_dims("data initialization", "rts", "vector_d", context__.to_vec(T,nt));
            rts = std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> >(T, Eigen::Matrix<double, Eigen::Dynamic, 1>(nt));
            vals_r__ = context__.vals_r("rts");
            pos__ = 0;
            size_t rts_j_1_max__ = nt;
            size_t rts_k_0_max__ = T;
            for (size_t j_1__ = 0; j_1__ < rts_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < rts_k_0_max__; ++k_0__) {
                    rts[k_0__](j_1__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 97;
            validate_non_negative_index("xC", "nt", nt);
            validate_non_negative_index("xC", "T", T);
            context__.validate_dims("data initialization", "xC", "vector_d", context__.to_vec(T,nt));
            xC = std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> >(T, Eigen::Matrix<double, Eigen::Dynamic, 1>(nt));
            vals_r__ = context__.vals_r("xC");
            pos__ = 0;
            size_t xC_j_1_max__ = nt;
            size_t xC_k_0_max__ = T;
            for (size_t j_1__ = 0; j_1__ < xC_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < xC_k_0_max__; ++k_0__) {
                    xC[k_0__](j_1__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 98;
            context__.validate_dims("data initialization", "distribution", "int", context__.to_vec());
            distribution = int(0);
            vals_i__ = context__.vals_i("distribution");
            pos__ = 0;
            distribution = vals_i__[pos__++];
            check_greater_or_equal(function__, "distribution", distribution, 0);
            check_less_or_equal(function__, "distribution", distribution, 1);
            current_statement_begin__ = 99;
            context__.validate_dims("data initialization", "meanstructure", "int", context__.to_vec());
            meanstructure = int(0);
            vals_i__ = context__.vals_i("meanstructure");
            pos__ = 0;
            meanstructure = vals_i__[pos__++];
            check_greater_or_equal(function__, "meanstructure", meanstructure, 0);
            check_less_or_equal(function__, "meanstructure", meanstructure, 2);
            // initialize transformed data variables
            current_statement_begin__ = 103;
            validate_non_negative_index("rts_m", "nt", nt);
            rts_m = Eigen::Matrix<double, Eigen::Dynamic, 1>(nt);
            stan::math::fill(rts_m, DUMMY_VAR__);
            current_statement_begin__ = 104;
            validate_non_negative_index("rts_sd", "nt", nt);
            rts_sd = Eigen::Matrix<double, Eigen::Dynamic, 1>(nt);
            stan::math::fill(rts_sd, DUMMY_VAR__);
            current_statement_begin__ = 107;
            validate_non_negative_index("xC_m", "nt", nt);
            validate_non_negative_index("xC_m", "nt", nt);
            validate_non_negative_index("xC_m", "T", T);
            xC_m = std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> >(T, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nt, nt));
            stan::math::fill(xC_m, DUMMY_VAR__);
            current_statement_begin__ = 108;
            xC_marker = int(0);
            stan::math::fill(xC_marker, std::numeric_limits<int>::min());
            stan::math::assign(xC_marker,0);
            current_statement_begin__ = 109;
            cp = double(0);
            stan::math::fill(cp, DUMMY_VAR__);
            // execute transformed data statements
            current_statement_begin__ = 111;
            for (int t = 1; t <= T; ++t) {
                current_statement_begin__ = 112;
                stan::model::assign(xC_m, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            diag_matrix(get_base1(xC, t, "xC", 1)), 
                            "assigning variable xC_m");
                current_statement_begin__ = 114;
                stan::math::assign(cp, sum(multiply(transpose(get_base1(xC_m, t, "xC_m", 1)), get_base1(xC_m, t, "xC_m", 1))));
                current_statement_begin__ = 115;
                if (as_bool(logical_neq(cp, 0))) {
                    current_statement_begin__ = 116;
                    stan::math::assign(xC_marker, (xC_marker + 1));
                }
            }
            current_statement_begin__ = 119;
            if (as_bool(logical_eq(meanstructure, 0))) {
                current_statement_begin__ = 120;
                for (int i = 1; i <= nt; ++i) {
                    current_statement_begin__ = 121;
                    stan::model::assign(rts_m, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                mean(stan::model::rvalue(rts, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), "rts")), 
                                "assigning variable rts_m");
                    current_statement_begin__ = 122;
                    stan::model::assign(rts_sd, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                sd(stan::model::rvalue(rts, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), "rts")), 
                                "assigning variable rts_sd");
                }
            } else if (as_bool((primitive_value(logical_eq(meanstructure, 1)) || primitive_value(logical_eq(meanstructure, 2))))) {
                current_statement_begin__ = 126;
                for (int i = 1; i <= nt; ++i) {
                    current_statement_begin__ = 127;
                    stan::model::assign(rts_m, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                get_base1(get_base1(rts, 1, "rts", 1), i, "rts", 2), 
                                "assigning variable rts_m");
                    current_statement_begin__ = 128;
                    stan::model::assign(rts_sd, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                sd(stan::model::rvalue(rts, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), "rts")), 
                                "assigning variable rts_sd");
                }
            }
            // validate transformed data
            current_statement_begin__ = 108;
            check_greater_or_equal(function__, "xC_marker", xC_marker, 0);
            current_statement_begin__ = 109;
            check_greater_or_equal(function__, "cp", cp, 0);
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 134;
            validate_non_negative_index("phi0", "nt", nt);
            num_params_r__ += nt;
            current_statement_begin__ = 139;
            validate_non_negative_index("phi", "nt", nt);
            validate_non_negative_index("phi", "nt", nt);
            num_params_r__ += (nt * nt);
            current_statement_begin__ = 140;
            validate_non_negative_index("theta", "nt", nt);
            validate_non_negative_index("theta", "nt", nt);
            num_params_r__ += (nt * nt);
            current_statement_begin__ = 145;
            validate_non_negative_index("beta", "nt", nt);
            num_params_r__ += nt;
            current_statement_begin__ = 148;
            validate_non_negative_index("c_h", "nt", nt);
            num_params_r__ += nt;
            current_statement_begin__ = 150;
            validate_non_negative_index("a_h_simplex", "Q", Q);
            validate_non_negative_index("a_h_simplex", "nt", nt);
            num_params_r__ += ((Q - 1) * nt);
            current_statement_begin__ = 151;
            validate_non_negative_index("a_h_sum", "nt", nt);
            num_params_r__ += nt;
            current_statement_begin__ = 152;
            validate_non_negative_index("b_h_simplex", "P", P);
            validate_non_negative_index("b_h_simplex", "nt", nt);
            num_params_r__ += ((P - 1) * nt);
            current_statement_begin__ = 153;
            validate_non_negative_index("b_h_sum_s", "nt", nt);
            num_params_r__ += nt;
            current_statement_begin__ = 157;
            validate_non_negative_index("R", "nt", nt);
            validate_non_negative_index("R", "nt", nt);
            num_params_r__ += ((nt * (nt - 1)) / 2);
            current_statement_begin__ = 160;
            validate_non_negative_index("D1_init", "nt", nt);
            num_params_r__ += nt;
            current_statement_begin__ = 163;
            num_params_r__ += 1;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_CCCMGARCH() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 134;
        if (!(context__.contains_r("phi0")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable phi0 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("phi0");
        pos__ = 0U;
        validate_non_negative_index("phi0", "nt", nt);
        context__.validate_dims("parameter initialization", "phi0", "vector_d", context__.to_vec(nt));
        Eigen::Matrix<double, Eigen::Dynamic, 1> phi0(nt);
        size_t phi0_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < phi0_j_1_max__; ++j_1__) {
            phi0(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(phi0);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable phi0: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 139;
        if (!(context__.contains_r("phi")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable phi missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("phi");
        pos__ = 0U;
        validate_non_negative_index("phi", "nt", nt);
        validate_non_negative_index("phi", "nt", nt);
        context__.validate_dims("parameter initialization", "phi", "matrix_d", context__.to_vec(nt,nt));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> phi(nt, nt);
        size_t phi_j_2_max__ = nt;
        size_t phi_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < phi_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
                phi(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_lub_unconstrain(-(1), 1, phi);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable phi: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 140;
        if (!(context__.contains_r("theta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable theta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("theta");
        pos__ = 0U;
        validate_non_negative_index("theta", "nt", nt);
        validate_non_negative_index("theta", "nt", nt);
        context__.validate_dims("parameter initialization", "theta", "matrix_d", context__.to_vec(nt,nt));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> theta(nt, nt);
        size_t theta_j_2_max__ = nt;
        size_t theta_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < theta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                theta(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_lub_unconstrain(-(1), 1, theta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable theta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 145;
        if (!(context__.contains_r("beta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        validate_non_negative_index("beta", "nt", nt);
        context__.validate_dims("parameter initialization", "beta", "vector_d", context__.to_vec(nt));
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta(nt);
        size_t beta_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            beta(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(beta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 148;
        if (!(context__.contains_r("c_h")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable c_h missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("c_h");
        pos__ = 0U;
        validate_non_negative_index("c_h", "nt", nt);
        context__.validate_dims("parameter initialization", "c_h", "vector_d", context__.to_vec(nt));
        Eigen::Matrix<double, Eigen::Dynamic, 1> c_h(nt);
        size_t c_h_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < c_h_j_1_max__; ++j_1__) {
            c_h(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(c_h);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable c_h: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 150;
        if (!(context__.contains_r("a_h_simplex")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable a_h_simplex missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("a_h_simplex");
        pos__ = 0U;
        validate_non_negative_index("a_h_simplex", "Q", Q);
        validate_non_negative_index("a_h_simplex", "nt", nt);
        context__.validate_dims("parameter initialization", "a_h_simplex", "vector_d", context__.to_vec(nt,Q));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > a_h_simplex(nt, Eigen::Matrix<double, Eigen::Dynamic, 1>(Q));
        size_t a_h_simplex_j_1_max__ = Q;
        size_t a_h_simplex_k_0_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < a_h_simplex_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < a_h_simplex_k_0_max__; ++k_0__) {
                a_h_simplex[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t a_h_simplex_i_0_max__ = nt;
        for (size_t i_0__ = 0; i_0__ < a_h_simplex_i_0_max__; ++i_0__) {
            try {
                writer__.simplex_unconstrain(a_h_simplex[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable a_h_simplex: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 151;
        if (!(context__.contains_r("a_h_sum")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable a_h_sum missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("a_h_sum");
        pos__ = 0U;
        validate_non_negative_index("a_h_sum", "nt", nt);
        context__.validate_dims("parameter initialization", "a_h_sum", "vector_d", context__.to_vec(nt));
        Eigen::Matrix<double, Eigen::Dynamic, 1> a_h_sum(nt);
        size_t a_h_sum_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < a_h_sum_j_1_max__; ++j_1__) {
            a_h_sum(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(0, 1, a_h_sum);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable a_h_sum: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 152;
        if (!(context__.contains_r("b_h_simplex")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable b_h_simplex missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("b_h_simplex");
        pos__ = 0U;
        validate_non_negative_index("b_h_simplex", "P", P);
        validate_non_negative_index("b_h_simplex", "nt", nt);
        context__.validate_dims("parameter initialization", "b_h_simplex", "vector_d", context__.to_vec(nt,P));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > b_h_simplex(nt, Eigen::Matrix<double, Eigen::Dynamic, 1>(P));
        size_t b_h_simplex_j_1_max__ = P;
        size_t b_h_simplex_k_0_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < b_h_simplex_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < b_h_simplex_k_0_max__; ++k_0__) {
                b_h_simplex[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t b_h_simplex_i_0_max__ = nt;
        for (size_t i_0__ = 0; i_0__ < b_h_simplex_i_0_max__; ++i_0__) {
            try {
                writer__.simplex_unconstrain(b_h_simplex[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable b_h_simplex: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 153;
        if (!(context__.contains_r("b_h_sum_s")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable b_h_sum_s missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("b_h_sum_s");
        pos__ = 0U;
        validate_non_negative_index("b_h_sum_s", "nt", nt);
        context__.validate_dims("parameter initialization", "b_h_sum_s", "vector_d", context__.to_vec(nt));
        Eigen::Matrix<double, Eigen::Dynamic, 1> b_h_sum_s(nt);
        size_t b_h_sum_s_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < b_h_sum_s_j_1_max__; ++j_1__) {
            b_h_sum_s(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(b_h_sum_s);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable b_h_sum_s: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 157;
        if (!(context__.contains_r("R")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable R missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("R");
        pos__ = 0U;
        validate_non_negative_index("R", "nt", nt);
        validate_non_negative_index("R", "nt", nt);
        context__.validate_dims("parameter initialization", "R", "matrix_d", context__.to_vec(nt,nt));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> R(nt, nt);
        size_t R_j_2_max__ = nt;
        size_t R_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < R_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < R_j_1_max__; ++j_1__) {
                R(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.corr_matrix_unconstrain(R);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable R: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 160;
        if (!(context__.contains_r("D1_init")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable D1_init missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("D1_init");
        pos__ = 0U;
        validate_non_negative_index("D1_init", "nt", nt);
        context__.validate_dims("parameter initialization", "D1_init", "vector_d", context__.to_vec(nt));
        Eigen::Matrix<double, Eigen::Dynamic, 1> D1_init(nt);
        size_t D1_init_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < D1_init_j_1_max__; ++j_1__) {
            D1_init(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, D1_init);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable D1_init: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 163;
        if (!(context__.contains_r("nu")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable nu missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("nu");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "nu", "double", context__.to_vec());
        double nu(0);
        nu = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(2, nu);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable nu: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 134;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> phi0;
            (void) phi0;  // dummy to suppress unused var warning
            if (jacobian__)
                phi0 = in__.vector_constrain(nt, lp__);
            else
                phi0 = in__.vector_constrain(nt);
            current_statement_begin__ = 139;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> phi;
            (void) phi;  // dummy to suppress unused var warning
            if (jacobian__)
                phi = in__.matrix_lub_constrain(-(1), 1, nt, nt, lp__);
            else
                phi = in__.matrix_lub_constrain(-(1), 1, nt, nt);
            current_statement_begin__ = 140;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> theta;
            (void) theta;  // dummy to suppress unused var warning
            if (jacobian__)
                theta = in__.matrix_lub_constrain(-(1), 1, nt, nt, lp__);
            else
                theta = in__.matrix_lub_constrain(-(1), 1, nt, nt);
            current_statement_begin__ = 145;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta;
            (void) beta;  // dummy to suppress unused var warning
            if (jacobian__)
                beta = in__.vector_constrain(nt, lp__);
            else
                beta = in__.vector_constrain(nt);
            current_statement_begin__ = 148;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> c_h;
            (void) c_h;  // dummy to suppress unused var warning
            if (jacobian__)
                c_h = in__.vector_constrain(nt, lp__);
            else
                c_h = in__.vector_constrain(nt);
            current_statement_begin__ = 150;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > a_h_simplex;
            size_t a_h_simplex_d_0_max__ = nt;
            a_h_simplex.reserve(a_h_simplex_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < a_h_simplex_d_0_max__; ++d_0__) {
                if (jacobian__)
                    a_h_simplex.push_back(in__.simplex_constrain(Q, lp__));
                else
                    a_h_simplex.push_back(in__.simplex_constrain(Q));
            }
            current_statement_begin__ = 151;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> a_h_sum;
            (void) a_h_sum;  // dummy to suppress unused var warning
            if (jacobian__)
                a_h_sum = in__.vector_lub_constrain(0, 1, nt, lp__);
            else
                a_h_sum = in__.vector_lub_constrain(0, 1, nt);
            current_statement_begin__ = 152;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > b_h_simplex;
            size_t b_h_simplex_d_0_max__ = nt;
            b_h_simplex.reserve(b_h_simplex_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < b_h_simplex_d_0_max__; ++d_0__) {
                if (jacobian__)
                    b_h_simplex.push_back(in__.simplex_constrain(P, lp__));
                else
                    b_h_simplex.push_back(in__.simplex_constrain(P));
            }
            current_statement_begin__ = 153;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> b_h_sum_s;
            (void) b_h_sum_s;  // dummy to suppress unused var warning
            if (jacobian__)
                b_h_sum_s = in__.vector_constrain(nt, lp__);
            else
                b_h_sum_s = in__.vector_constrain(nt);
            current_statement_begin__ = 157;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> R;
            (void) R;  // dummy to suppress unused var warning
            if (jacobian__)
                R = in__.corr_matrix_constrain(nt, lp__);
            else
                R = in__.corr_matrix_constrain(nt);
            current_statement_begin__ = 160;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> D1_init;
            (void) D1_init;  // dummy to suppress unused var warning
            if (jacobian__)
                D1_init = in__.vector_lb_constrain(0, nt, lp__);
            else
                D1_init = in__.vector_lb_constrain(0, nt);
            current_statement_begin__ = 163;
            local_scalar_t__ nu;
            (void) nu;  // dummy to suppress unused var warning
            if (jacobian__)
                nu = in__.scalar_lb_constrain(2, lp__);
            else
                nu = in__.scalar_lb_constrain(2);
            // transformed parameters
            current_statement_begin__ = 167;
            validate_non_negative_index("H", "nt", nt);
            validate_non_negative_index("H", "nt", nt);
            validate_non_negative_index("H", "T", T);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> > H(T, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic>(nt, nt));
            stan::math::initialize(H, DUMMY_VAR__);
            stan::math::fill(H, DUMMY_VAR__);
            current_statement_begin__ = 168;
            validate_non_negative_index("rr", "nt", nt);
            validate_non_negative_index("rr", "(T - 1)", (T - 1));
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > rr((T - 1), Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>(nt));
            stan::math::initialize(rr, DUMMY_VAR__);
            stan::math::fill(rr, DUMMY_VAR__);
            current_statement_begin__ = 169;
            validate_non_negative_index("mu", "nt", nt);
            validate_non_negative_index("mu", "T", T);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > mu(T, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>(nt));
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            current_statement_begin__ = 170;
            validate_non_negative_index("D", "nt", nt);
            validate_non_negative_index("D", "T", T);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > D(T, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>(nt));
            stan::math::initialize(D, DUMMY_VAR__);
            stan::math::fill(D, DUMMY_VAR__);
            current_statement_begin__ = 171;
            validate_non_negative_index("vd", "nt", nt);
            std::vector<local_scalar_t__> vd(nt, local_scalar_t__(0));
            stan::math::initialize(vd, DUMMY_VAR__);
            stan::math::fill(vd, DUMMY_VAR__);
            current_statement_begin__ = 172;
            validate_non_negative_index("ma_d", "nt", nt);
            std::vector<local_scalar_t__> ma_d(nt, local_scalar_t__(0));
            stan::math::initialize(ma_d, DUMMY_VAR__);
            stan::math::fill(ma_d, DUMMY_VAR__);
            current_statement_begin__ = 173;
            validate_non_negative_index("ar_d", "nt", nt);
            std::vector<local_scalar_t__> ar_d(nt, local_scalar_t__(0));
            stan::math::initialize(ar_d, DUMMY_VAR__);
            stan::math::fill(ar_d, DUMMY_VAR__);
            current_statement_begin__ = 174;
            validate_non_negative_index("a_h", "nt", nt);
            validate_non_negative_index("a_h", "Q", Q);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > a_h(Q, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>(nt));
            stan::math::initialize(a_h, DUMMY_VAR__);
            stan::math::fill(a_h, DUMMY_VAR__);
            stan::math::assign(a_h,simplex_to_bh(a_h_simplex, a_h_sum, pstream__));
            current_statement_begin__ = 175;
            validate_non_negative_index("UPs", "nt", nt);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> UPs(nt);
            stan::math::initialize(UPs, DUMMY_VAR__);
            stan::math::fill(UPs, DUMMY_VAR__);
            stan::math::assign(UPs,upper_limits(a_h, pstream__));
            current_statement_begin__ = 176;
            validate_non_negative_index("ULs", "nt", nt);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> ULs(nt);
            stan::math::initialize(ULs, DUMMY_VAR__);
            stan::math::fill(ULs, DUMMY_VAR__);
            stan::math::assign(ULs,raw_sum_to_b_h_sum(b_h_sum_s, UPs, pstream__));
            current_statement_begin__ = 177;
            validate_non_negative_index("b_h", "nt", nt);
            validate_non_negative_index("b_h", "P", P);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > b_h(P, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>(nt));
            stan::math::initialize(b_h, DUMMY_VAR__);
            stan::math::fill(b_h, DUMMY_VAR__);
            stan::math::assign(b_h,simplex_to_bh(b_h_simplex, ULs, pstream__));
            // transformed parameters block statements
            current_statement_begin__ = 180;
            stan::model::assign(mu, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                        phi0, 
                        "assigning variable mu");
            current_statement_begin__ = 182;
            stan::model::assign(D, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                        D1_init, 
                        "assigning variable D");
            current_statement_begin__ = 183;
            stan::model::assign(H, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                        quad_form_diag(R, stan::model::rvalue(D, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "D")), 
                        "assigning variable H");
            current_statement_begin__ = 185;
            for (int t = 2; t <= T; ++t) {
                current_statement_begin__ = 188;
                if (as_bool(logical_eq(meanstructure, 0))) {
                    current_statement_begin__ = 190;
                    stan::model::assign(mu, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                                phi0, 
                                "assigning variable mu");
                } else if (as_bool(logical_eq(meanstructure, 1))) {
                    current_statement_begin__ = 193;
                    stan::model::assign(mu, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                                stan::model::deep_copy(add(add(phi0, multiply(phi, stan::model::rvalue(rts, stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rts"))), multiply(theta, subtract(stan::model::rvalue(rts, stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rts"), stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "mu"))))), 
                                "assigning variable mu");
                } else if (as_bool(logical_eq(meanstructure, 2))) {
                    current_statement_begin__ = 196;
                    stan::model::assign(mu, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                                add(phi0, multiply(phi, stan::model::rvalue(rts, stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rts"))), 
                                "assigning variable mu");
                }
                current_statement_begin__ = 200;
                for (int d = 1; d <= nt; ++d) {
                    current_statement_begin__ = 201;
                    stan::model::assign(vd, 
                                stan::model::cons_list(stan::model::index_uni(d), stan::model::nil_index_list()), 
                                0.0, 
                                "assigning variable vd");
                    current_statement_begin__ = 202;
                    stan::model::assign(ma_d, 
                                stan::model::cons_list(stan::model::index_uni(d), stan::model::nil_index_list()), 
                                0.0, 
                                "assigning variable ma_d");
                    current_statement_begin__ = 203;
                    stan::model::assign(ar_d, 
                                stan::model::cons_list(stan::model::index_uni(d), stan::model::nil_index_list()), 
                                0.0, 
                                "assigning variable ar_d");
                    current_statement_begin__ = 205;
                    for (int q = 1; q <= std::min((t - 1), Q); ++q) {
                        current_statement_begin__ = 206;
                        stan::model::assign(rr, 
                                    stan::model::cons_list(stan::model::index_uni((t - q)), stan::model::cons_list(stan::model::index_uni(d), stan::model::nil_index_list())), 
                                    square((get_base1(get_base1(rts, (t - q), "rts", 1), d, "rts", 2) - get_base1(get_base1(mu, (t - q), "mu", 1), d, "mu", 2))), 
                                    "assigning variable rr");
                        current_statement_begin__ = 207;
                        stan::model::assign(ma_d, 
                                    stan::model::cons_list(stan::model::index_uni(d), stan::model::nil_index_list()), 
                                    (get_base1(ma_d, d, "ma_d", 1) + (get_base1(get_base1(a_h, q, "a_h", 1), d, "a_h", 2) * get_base1(get_base1(rr, (t - q), "rr", 1), d, "rr", 2))), 
                                    "assigning variable ma_d");
                    }
                    current_statement_begin__ = 209;
                    for (int p = 1; p <= std::min((t - 1), P); ++p) {
                        current_statement_begin__ = 210;
                        stan::model::assign(ar_d, 
                                    stan::model::cons_list(stan::model::index_uni(d), stan::model::nil_index_list()), 
                                    (get_base1(ar_d, d, "ar_d", 1) + (get_base1(get_base1(b_h, p, "b_h", 1), d, "b_h", 2) * pow(get_base1(get_base1(D, (t - p), "D", 1), d, "D", 2), 2))), 
                                    "assigning variable ar_d");
                    }
                    current_statement_begin__ = 212;
                    if (as_bool(logical_gte(xC_marker, 1))) {
                        current_statement_begin__ = 213;
                        stan::model::assign(vd, 
                                    stan::model::cons_list(stan::model::index_uni(d), stan::model::nil_index_list()), 
                                    ((stan::math::exp((get_base1(c_h, d, "c_h", 1) + (get_base1(beta, d, "beta", 1) * get_base1(get_base1(xC, t, "xC", 1), d, "xC", 2)))) + get_base1(ma_d, d, "ma_d", 1)) + get_base1(ar_d, d, "ar_d", 1)), 
                                    "assigning variable vd");
                    } else if (as_bool(logical_eq(xC_marker, 0))) {
                        current_statement_begin__ = 215;
                        stan::model::assign(vd, 
                                    stan::model::cons_list(stan::model::index_uni(d), stan::model::nil_index_list()), 
                                    ((stan::math::exp(get_base1(c_h, d, "c_h", 1)) + get_base1(ma_d, d, "ma_d", 1)) + get_base1(ar_d, d, "ar_d", 1)), 
                                    "assigning variable vd");
                    }
                    current_statement_begin__ = 217;
                    stan::model::assign(D, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_uni(d), stan::model::nil_index_list())), 
                                stan::math::sqrt(get_base1(vd, d, "vd", 1)), 
                                "assigning variable D");
                }
                current_statement_begin__ = 219;
                stan::model::assign(H, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                            quad_form_diag(R, stan::model::rvalue(D, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "D")), 
                            "assigning variable H");
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 167;
            size_t H_k_0_max__ = T;
            size_t H_j_1_max__ = nt;
            size_t H_j_2_max__ = nt;
            for (size_t k_0__ = 0; k_0__ < H_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < H_j_1_max__; ++j_1__) {
                    for (size_t j_2__ = 0; j_2__ < H_j_2_max__; ++j_2__) {
                        if (stan::math::is_uninitialized(H[k_0__](j_1__, j_2__))) {
                            std::stringstream msg__;
                            msg__ << "Undefined transformed parameter: H" << "[" << k_0__ << "]" << "(" << j_1__ << ", " << j_2__ << ")";
                            stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable H: ") + msg__.str()), current_statement_begin__, prog_reader__());
                        }
                    }
                }
            }
            size_t H_i_0_max__ = T;
            for (size_t i_0__ = 0; i_0__ < H_i_0_max__; ++i_0__) {
                stan::math::check_cov_matrix(function__, "H[i_0__]", H[i_0__]);
            }
            current_statement_begin__ = 168;
            size_t rr_k_0_max__ = (T - 1);
            size_t rr_j_1_max__ = nt;
            for (size_t k_0__ = 0; k_0__ < rr_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < rr_j_1_max__; ++j_1__) {
                    if (stan::math::is_uninitialized(rr[k_0__](j_1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: rr" << "[" << k_0__ << "]" << "(" << j_1__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable rr: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 169;
            size_t mu_k_0_max__ = T;
            size_t mu_j_1_max__ = nt;
            for (size_t k_0__ = 0; k_0__ < mu_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                    if (stan::math::is_uninitialized(mu[k_0__](j_1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: mu" << "[" << k_0__ << "]" << "(" << j_1__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable mu: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 170;
            size_t D_k_0_max__ = T;
            size_t D_j_1_max__ = nt;
            for (size_t k_0__ = 0; k_0__ < D_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < D_j_1_max__; ++j_1__) {
                    if (stan::math::is_uninitialized(D[k_0__](j_1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: D" << "[" << k_0__ << "]" << "(" << j_1__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable D: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 171;
            size_t vd_k_0_max__ = nt;
            for (size_t k_0__ = 0; k_0__ < vd_k_0_max__; ++k_0__) {
                if (stan::math::is_uninitialized(vd[k_0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: vd" << "[" << k_0__ << "]";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable vd: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            size_t vd_i_0_max__ = nt;
            for (size_t i_0__ = 0; i_0__ < vd_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "vd[i_0__]", vd[i_0__], 0);
            }
            current_statement_begin__ = 172;
            size_t ma_d_k_0_max__ = nt;
            for (size_t k_0__ = 0; k_0__ < ma_d_k_0_max__; ++k_0__) {
                if (stan::math::is_uninitialized(ma_d[k_0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: ma_d" << "[" << k_0__ << "]";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable ma_d: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            size_t ma_d_i_0_max__ = nt;
            for (size_t i_0__ = 0; i_0__ < ma_d_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "ma_d[i_0__]", ma_d[i_0__], 0);
            }
            current_statement_begin__ = 173;
            size_t ar_d_k_0_max__ = nt;
            for (size_t k_0__ = 0; k_0__ < ar_d_k_0_max__; ++k_0__) {
                if (stan::math::is_uninitialized(ar_d[k_0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: ar_d" << "[" << k_0__ << "]";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable ar_d: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            size_t ar_d_i_0_max__ = nt;
            for (size_t i_0__ = 0; i_0__ < ar_d_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "ar_d[i_0__]", ar_d[i_0__], 0);
            }
            current_statement_begin__ = 174;
            size_t a_h_k_0_max__ = Q;
            size_t a_h_j_1_max__ = nt;
            for (size_t k_0__ = 0; k_0__ < a_h_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < a_h_j_1_max__; ++j_1__) {
                    if (stan::math::is_uninitialized(a_h[k_0__](j_1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: a_h" << "[" << k_0__ << "]" << "(" << j_1__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable a_h: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            size_t a_h_i_0_max__ = Q;
            for (size_t i_0__ = 0; i_0__ < a_h_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "a_h[i_0__]", a_h[i_0__], 0);
                check_less_or_equal(function__, "a_h[i_0__]", a_h[i_0__], 1);
            }
            current_statement_begin__ = 175;
            size_t UPs_j_1_max__ = nt;
            for (size_t j_1__ = 0; j_1__ < UPs_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(UPs(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: UPs" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable UPs: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 176;
            size_t ULs_j_1_max__ = nt;
            for (size_t j_1__ = 0; j_1__ < ULs_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(ULs(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: ULs" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable ULs: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 177;
            size_t b_h_k_0_max__ = P;
            size_t b_h_j_1_max__ = nt;
            for (size_t k_0__ = 0; k_0__ < b_h_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < b_h_j_1_max__; ++j_1__) {
                    if (stan::math::is_uninitialized(b_h[k_0__](j_1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: b_h" << "[" << k_0__ << "]" << "(" << j_1__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable b_h: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            size_t b_h_i_0_max__ = P;
            for (size_t i_0__ = 0; i_0__ < b_h_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "b_h[i_0__]", b_h[i_0__], 0);
                check_less_or_equal(function__, "b_h[i_0__]", b_h[i_0__], 1);
            }
            // model body
            current_statement_begin__ = 225;
            for (int k = 1; k <= nt; ++k) {
                current_statement_begin__ = 226;
                lp_accum__.add(uniform_log<propto__>(get_base1(ULs, k, "ULs", 1), 0, get_base1(UPs, k, "UPs", 1)));
                current_statement_begin__ = 227;
                lp_accum__.add(a_b_scale_jacobian(0, get_base1(ULs, k, "ULs", 1), get_base1(b_h_sum_s, k, "b_h_sum_s", 1), pstream__));
            }
            current_statement_begin__ = 229;
            lp_accum__.add(std_normal_log<propto__>(to_vector(beta)));
            current_statement_begin__ = 230;
            lp_accum__.add(std_normal_log<propto__>(to_vector(c_h)));
            current_statement_begin__ = 231;
            if (as_bool(logical_eq(distribution, 1))) {
                current_statement_begin__ = 232;
                lp_accum__.add(normal_log<propto__>(nu, nt, 50));
            }
            current_statement_begin__ = 233;
            lp_accum__.add(lognormal_log<propto__>(to_vector(D1_init), 0, 1));
            current_statement_begin__ = 234;
            lp_accum__.add(std_normal_log<propto__>(to_vector(theta)));
            current_statement_begin__ = 235;
            lp_accum__.add(std_normal_log<propto__>(to_vector(phi)));
            current_statement_begin__ = 236;
            lp_accum__.add(multi_normal_log<propto__>(phi0, rts_m, diag_matrix(rts_sd)));
            current_statement_begin__ = 237;
            lp_accum__.add(lkj_corr_log<propto__>(R, 1));
            current_statement_begin__ = 239;
            if (as_bool(logical_eq(distribution, 0))) {
                current_statement_begin__ = 240;
                for (int t = 1; t <= T; ++t) {
                    current_statement_begin__ = 241;
                    lp_accum__.add(multi_normal_log<propto__>(stan::model::rvalue(rts, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rts"), stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "mu"), stan::model::rvalue(H, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "H")));
                }
            } else if (as_bool(logical_eq(distribution, 1))) {
                current_statement_begin__ = 245;
                for (int t = 1; t <= T; ++t) {
                    current_statement_begin__ = 246;
                    lp_accum__.add(multi_student_t_log<propto__>(stan::model::rvalue(rts, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rts"), nu, stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "mu"), stan::model::rvalue(H, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "H")));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("phi0");
        names__.push_back("phi");
        names__.push_back("theta");
        names__.push_back("beta");
        names__.push_back("c_h");
        names__.push_back("a_h_simplex");
        names__.push_back("a_h_sum");
        names__.push_back("b_h_simplex");
        names__.push_back("b_h_sum_s");
        names__.push_back("R");
        names__.push_back("D1_init");
        names__.push_back("nu");
        names__.push_back("H");
        names__.push_back("rr");
        names__.push_back("mu");
        names__.push_back("D");
        names__.push_back("vd");
        names__.push_back("ma_d");
        names__.push_back("ar_d");
        names__.push_back("a_h");
        names__.push_back("UPs");
        names__.push_back("ULs");
        names__.push_back("b_h");
        names__.push_back("rts_out");
        names__.push_back("log_lik");
        names__.push_back("corH");
        names__.push_back("c_h_var");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dims__.push_back(Q);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dims__.push_back(P);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((T - 1));
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Q);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(P);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_CCCMGARCH_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> phi0 = in__.vector_constrain(nt);
        size_t phi0_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < phi0_j_1_max__; ++j_1__) {
            vars__.push_back(phi0(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> phi = in__.matrix_lub_constrain(-(1), 1, nt, nt);
        size_t phi_j_2_max__ = nt;
        size_t phi_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < phi_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
                vars__.push_back(phi(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> theta = in__.matrix_lub_constrain(-(1), 1, nt, nt);
        size_t theta_j_2_max__ = nt;
        size_t theta_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < theta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                vars__.push_back(theta(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta = in__.vector_constrain(nt);
        size_t beta_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            vars__.push_back(beta(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> c_h = in__.vector_constrain(nt);
        size_t c_h_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < c_h_j_1_max__; ++j_1__) {
            vars__.push_back(c_h(j_1__));
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > a_h_simplex;
        size_t a_h_simplex_d_0_max__ = nt;
        a_h_simplex.reserve(a_h_simplex_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < a_h_simplex_d_0_max__; ++d_0__) {
            a_h_simplex.push_back(in__.simplex_constrain(Q));
        }
        size_t a_h_simplex_j_1_max__ = Q;
        size_t a_h_simplex_k_0_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < a_h_simplex_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < a_h_simplex_k_0_max__; ++k_0__) {
                vars__.push_back(a_h_simplex[k_0__](j_1__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> a_h_sum = in__.vector_lub_constrain(0, 1, nt);
        size_t a_h_sum_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < a_h_sum_j_1_max__; ++j_1__) {
            vars__.push_back(a_h_sum(j_1__));
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > b_h_simplex;
        size_t b_h_simplex_d_0_max__ = nt;
        b_h_simplex.reserve(b_h_simplex_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < b_h_simplex_d_0_max__; ++d_0__) {
            b_h_simplex.push_back(in__.simplex_constrain(P));
        }
        size_t b_h_simplex_j_1_max__ = P;
        size_t b_h_simplex_k_0_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < b_h_simplex_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < b_h_simplex_k_0_max__; ++k_0__) {
                vars__.push_back(b_h_simplex[k_0__](j_1__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> b_h_sum_s = in__.vector_constrain(nt);
        size_t b_h_sum_s_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < b_h_sum_s_j_1_max__; ++j_1__) {
            vars__.push_back(b_h_sum_s(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> R = in__.corr_matrix_constrain(nt);
        size_t R_j_2_max__ = nt;
        size_t R_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < R_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < R_j_1_max__; ++j_1__) {
                vars__.push_back(R(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> D1_init = in__.vector_lb_constrain(0, nt);
        size_t D1_init_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < D1_init_j_1_max__; ++j_1__) {
            vars__.push_back(D1_init(j_1__));
        }
        double nu = in__.scalar_lb_constrain(2);
        vars__.push_back(nu);
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 167;
            validate_non_negative_index("H", "nt", nt);
            validate_non_negative_index("H", "nt", nt);
            validate_non_negative_index("H", "T", T);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > H(T, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nt, nt));
            stan::math::initialize(H, DUMMY_VAR__);
            stan::math::fill(H, DUMMY_VAR__);
            current_statement_begin__ = 168;
            validate_non_negative_index("rr", "nt", nt);
            validate_non_negative_index("rr", "(T - 1)", (T - 1));
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > rr((T - 1), Eigen::Matrix<double, Eigen::Dynamic, 1>(nt));
            stan::math::initialize(rr, DUMMY_VAR__);
            stan::math::fill(rr, DUMMY_VAR__);
            current_statement_begin__ = 169;
            validate_non_negative_index("mu", "nt", nt);
            validate_non_negative_index("mu", "T", T);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > mu(T, Eigen::Matrix<double, Eigen::Dynamic, 1>(nt));
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            current_statement_begin__ = 170;
            validate_non_negative_index("D", "nt", nt);
            validate_non_negative_index("D", "T", T);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > D(T, Eigen::Matrix<double, Eigen::Dynamic, 1>(nt));
            stan::math::initialize(D, DUMMY_VAR__);
            stan::math::fill(D, DUMMY_VAR__);
            current_statement_begin__ = 171;
            validate_non_negative_index("vd", "nt", nt);
            std::vector<double> vd(nt, double(0));
            stan::math::initialize(vd, DUMMY_VAR__);
            stan::math::fill(vd, DUMMY_VAR__);
            current_statement_begin__ = 172;
            validate_non_negative_index("ma_d", "nt", nt);
            std::vector<double> ma_d(nt, double(0));
            stan::math::initialize(ma_d, DUMMY_VAR__);
            stan::math::fill(ma_d, DUMMY_VAR__);
            current_statement_begin__ = 173;
            validate_non_negative_index("ar_d", "nt", nt);
            std::vector<double> ar_d(nt, double(0));
            stan::math::initialize(ar_d, DUMMY_VAR__);
            stan::math::fill(ar_d, DUMMY_VAR__);
            current_statement_begin__ = 174;
            validate_non_negative_index("a_h", "nt", nt);
            validate_non_negative_index("a_h", "Q", Q);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > a_h(Q, Eigen::Matrix<double, Eigen::Dynamic, 1>(nt));
            stan::math::initialize(a_h, DUMMY_VAR__);
            stan::math::fill(a_h, DUMMY_VAR__);
            stan::math::assign(a_h,simplex_to_bh(a_h_simplex, a_h_sum, pstream__));
            current_statement_begin__ = 175;
            validate_non_negative_index("UPs", "nt", nt);
            Eigen::Matrix<double, Eigen::Dynamic, 1> UPs(nt);
            stan::math::initialize(UPs, DUMMY_VAR__);
            stan::math::fill(UPs, DUMMY_VAR__);
            stan::math::assign(UPs,upper_limits(a_h, pstream__));
            current_statement_begin__ = 176;
            validate_non_negative_index("ULs", "nt", nt);
            Eigen::Matrix<double, Eigen::Dynamic, 1> ULs(nt);
            stan::math::initialize(ULs, DUMMY_VAR__);
            stan::math::fill(ULs, DUMMY_VAR__);
            stan::math::assign(ULs,raw_sum_to_b_h_sum(b_h_sum_s, UPs, pstream__));
            current_statement_begin__ = 177;
            validate_non_negative_index("b_h", "nt", nt);
            validate_non_negative_index("b_h", "P", P);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > b_h(P, Eigen::Matrix<double, Eigen::Dynamic, 1>(nt));
            stan::math::initialize(b_h, DUMMY_VAR__);
            stan::math::fill(b_h, DUMMY_VAR__);
            stan::math::assign(b_h,simplex_to_bh(b_h_simplex, ULs, pstream__));
            // do transformed parameters statements
            current_statement_begin__ = 180;
            stan::model::assign(mu, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                        phi0, 
                        "assigning variable mu");
            current_statement_begin__ = 182;
            stan::model::assign(D, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                        D1_init, 
                        "assigning variable D");
            current_statement_begin__ = 183;
            stan::model::assign(H, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                        quad_form_diag(R, stan::model::rvalue(D, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "D")), 
                        "assigning variable H");
            current_statement_begin__ = 185;
            for (int t = 2; t <= T; ++t) {
                current_statement_begin__ = 188;
                if (as_bool(logical_eq(meanstructure, 0))) {
                    current_statement_begin__ = 190;
                    stan::model::assign(mu, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                                phi0, 
                                "assigning variable mu");
                } else if (as_bool(logical_eq(meanstructure, 1))) {
                    current_statement_begin__ = 193;
                    stan::model::assign(mu, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                                stan::model::deep_copy(add(add(phi0, multiply(phi, stan::model::rvalue(rts, stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rts"))), multiply(theta, subtract(stan::model::rvalue(rts, stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rts"), stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "mu"))))), 
                                "assigning variable mu");
                } else if (as_bool(logical_eq(meanstructure, 2))) {
                    current_statement_begin__ = 196;
                    stan::model::assign(mu, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                                add(phi0, multiply(phi, stan::model::rvalue(rts, stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rts"))), 
                                "assigning variable mu");
                }
                current_statement_begin__ = 200;
                for (int d = 1; d <= nt; ++d) {
                    current_statement_begin__ = 201;
                    stan::model::assign(vd, 
                                stan::model::cons_list(stan::model::index_uni(d), stan::model::nil_index_list()), 
                                0.0, 
                                "assigning variable vd");
                    current_statement_begin__ = 202;
                    stan::model::assign(ma_d, 
                                stan::model::cons_list(stan::model::index_uni(d), stan::model::nil_index_list()), 
                                0.0, 
                                "assigning variable ma_d");
                    current_statement_begin__ = 203;
                    stan::model::assign(ar_d, 
                                stan::model::cons_list(stan::model::index_uni(d), stan::model::nil_index_list()), 
                                0.0, 
                                "assigning variable ar_d");
                    current_statement_begin__ = 205;
                    for (int q = 1; q <= std::min((t - 1), Q); ++q) {
                        current_statement_begin__ = 206;
                        stan::model::assign(rr, 
                                    stan::model::cons_list(stan::model::index_uni((t - q)), stan::model::cons_list(stan::model::index_uni(d), stan::model::nil_index_list())), 
                                    square((get_base1(get_base1(rts, (t - q), "rts", 1), d, "rts", 2) - get_base1(get_base1(mu, (t - q), "mu", 1), d, "mu", 2))), 
                                    "assigning variable rr");
                        current_statement_begin__ = 207;
                        stan::model::assign(ma_d, 
                                    stan::model::cons_list(stan::model::index_uni(d), stan::model::nil_index_list()), 
                                    (get_base1(ma_d, d, "ma_d", 1) + (get_base1(get_base1(a_h, q, "a_h", 1), d, "a_h", 2) * get_base1(get_base1(rr, (t - q), "rr", 1), d, "rr", 2))), 
                                    "assigning variable ma_d");
                    }
                    current_statement_begin__ = 209;
                    for (int p = 1; p <= std::min((t - 1), P); ++p) {
                        current_statement_begin__ = 210;
                        stan::model::assign(ar_d, 
                                    stan::model::cons_list(stan::model::index_uni(d), stan::model::nil_index_list()), 
                                    (get_base1(ar_d, d, "ar_d", 1) + (get_base1(get_base1(b_h, p, "b_h", 1), d, "b_h", 2) * pow(get_base1(get_base1(D, (t - p), "D", 1), d, "D", 2), 2))), 
                                    "assigning variable ar_d");
                    }
                    current_statement_begin__ = 212;
                    if (as_bool(logical_gte(xC_marker, 1))) {
                        current_statement_begin__ = 213;
                        stan::model::assign(vd, 
                                    stan::model::cons_list(stan::model::index_uni(d), stan::model::nil_index_list()), 
                                    ((stan::math::exp((get_base1(c_h, d, "c_h", 1) + (get_base1(beta, d, "beta", 1) * get_base1(get_base1(xC, t, "xC", 1), d, "xC", 2)))) + get_base1(ma_d, d, "ma_d", 1)) + get_base1(ar_d, d, "ar_d", 1)), 
                                    "assigning variable vd");
                    } else if (as_bool(logical_eq(xC_marker, 0))) {
                        current_statement_begin__ = 215;
                        stan::model::assign(vd, 
                                    stan::model::cons_list(stan::model::index_uni(d), stan::model::nil_index_list()), 
                                    ((stan::math::exp(get_base1(c_h, d, "c_h", 1)) + get_base1(ma_d, d, "ma_d", 1)) + get_base1(ar_d, d, "ar_d", 1)), 
                                    "assigning variable vd");
                    }
                    current_statement_begin__ = 217;
                    stan::model::assign(D, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_uni(d), stan::model::nil_index_list())), 
                                stan::math::sqrt(get_base1(vd, d, "vd", 1)), 
                                "assigning variable D");
                }
                current_statement_begin__ = 219;
                stan::model::assign(H, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                            quad_form_diag(R, stan::model::rvalue(D, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "D")), 
                            "assigning variable H");
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 167;
            size_t H_i_0_max__ = T;
            for (size_t i_0__ = 0; i_0__ < H_i_0_max__; ++i_0__) {
                stan::math::check_cov_matrix(function__, "H[i_0__]", H[i_0__]);
            }
            current_statement_begin__ = 171;
            size_t vd_i_0_max__ = nt;
            for (size_t i_0__ = 0; i_0__ < vd_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "vd[i_0__]", vd[i_0__], 0);
            }
            current_statement_begin__ = 172;
            size_t ma_d_i_0_max__ = nt;
            for (size_t i_0__ = 0; i_0__ < ma_d_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "ma_d[i_0__]", ma_d[i_0__], 0);
            }
            current_statement_begin__ = 173;
            size_t ar_d_i_0_max__ = nt;
            for (size_t i_0__ = 0; i_0__ < ar_d_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "ar_d[i_0__]", ar_d[i_0__], 0);
            }
            current_statement_begin__ = 174;
            size_t a_h_i_0_max__ = Q;
            for (size_t i_0__ = 0; i_0__ < a_h_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "a_h[i_0__]", a_h[i_0__], 0);
                check_less_or_equal(function__, "a_h[i_0__]", a_h[i_0__], 1);
            }
            current_statement_begin__ = 177;
            size_t b_h_i_0_max__ = P;
            for (size_t i_0__ = 0; i_0__ < b_h_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "b_h[i_0__]", b_h[i_0__], 0);
                check_less_or_equal(function__, "b_h[i_0__]", b_h[i_0__], 1);
            }
            // write transformed parameters
            if (include_tparams__) {
                size_t H_j_2_max__ = nt;
                size_t H_j_1_max__ = nt;
                size_t H_k_0_max__ = T;
                for (size_t j_2__ = 0; j_2__ < H_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < H_j_1_max__; ++j_1__) {
                        for (size_t k_0__ = 0; k_0__ < H_k_0_max__; ++k_0__) {
                            vars__.push_back(H[k_0__](j_1__, j_2__));
                        }
                    }
                }
                size_t rr_j_1_max__ = nt;
                size_t rr_k_0_max__ = (T - 1);
                for (size_t j_1__ = 0; j_1__ < rr_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < rr_k_0_max__; ++k_0__) {
                        vars__.push_back(rr[k_0__](j_1__));
                    }
                }
                size_t mu_j_1_max__ = nt;
                size_t mu_k_0_max__ = T;
                for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < mu_k_0_max__; ++k_0__) {
                        vars__.push_back(mu[k_0__](j_1__));
                    }
                }
                size_t D_j_1_max__ = nt;
                size_t D_k_0_max__ = T;
                for (size_t j_1__ = 0; j_1__ < D_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < D_k_0_max__; ++k_0__) {
                        vars__.push_back(D[k_0__](j_1__));
                    }
                }
                size_t vd_k_0_max__ = nt;
                for (size_t k_0__ = 0; k_0__ < vd_k_0_max__; ++k_0__) {
                    vars__.push_back(vd[k_0__]);
                }
                size_t ma_d_k_0_max__ = nt;
                for (size_t k_0__ = 0; k_0__ < ma_d_k_0_max__; ++k_0__) {
                    vars__.push_back(ma_d[k_0__]);
                }
                size_t ar_d_k_0_max__ = nt;
                for (size_t k_0__ = 0; k_0__ < ar_d_k_0_max__; ++k_0__) {
                    vars__.push_back(ar_d[k_0__]);
                }
                size_t a_h_j_1_max__ = nt;
                size_t a_h_k_0_max__ = Q;
                for (size_t j_1__ = 0; j_1__ < a_h_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < a_h_k_0_max__; ++k_0__) {
                        vars__.push_back(a_h[k_0__](j_1__));
                    }
                }
                size_t UPs_j_1_max__ = nt;
                for (size_t j_1__ = 0; j_1__ < UPs_j_1_max__; ++j_1__) {
                    vars__.push_back(UPs(j_1__));
                }
                size_t ULs_j_1_max__ = nt;
                for (size_t j_1__ = 0; j_1__ < ULs_j_1_max__; ++j_1__) {
                    vars__.push_back(ULs(j_1__));
                }
                size_t b_h_j_1_max__ = nt;
                size_t b_h_k_0_max__ = P;
                for (size_t j_1__ = 0; j_1__ < b_h_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < b_h_k_0_max__; ++k_0__) {
                        vars__.push_back(b_h[k_0__](j_1__));
                    }
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 252;
            validate_non_negative_index("rts_out", "nt", nt);
            validate_non_negative_index("rts_out", "T", T);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> rts_out(nt, T);
            stan::math::initialize(rts_out, DUMMY_VAR__);
            stan::math::fill(rts_out, DUMMY_VAR__);
            current_statement_begin__ = 253;
            validate_non_negative_index("log_lik", "T", T);
            std::vector<double> log_lik(T, double(0));
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            current_statement_begin__ = 254;
            validate_non_negative_index("corH", "nt", nt);
            validate_non_negative_index("corH", "nt", nt);
            validate_non_negative_index("corH", "T", T);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > corH(T, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nt, nt));
            stan::math::initialize(corH, DUMMY_VAR__);
            stan::math::fill(corH, DUMMY_VAR__);
            current_statement_begin__ = 255;
            validate_non_negative_index("c_h_var", "nt", nt);
            Eigen::Matrix<double, Eigen::Dynamic, 1> c_h_var(nt);
            stan::math::initialize(c_h_var, DUMMY_VAR__);
            stan::math::fill(c_h_var, DUMMY_VAR__);
            stan::math::assign(c_h_var,stan::math::exp(c_h));
            // generated quantities statements
            current_statement_begin__ = 259;
            if (as_bool(logical_eq(distribution, 0))) {
                current_statement_begin__ = 260;
                for (int t = 1; t <= T; ++t) {
                    current_statement_begin__ = 261;
                    stan::model::assign(rts_out, 
                                stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                multi_normal_rng(stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "mu"), stan::model::rvalue(H, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "H"), base_rng__), 
                                "assigning variable rts_out");
                    current_statement_begin__ = 262;
                    stan::model::assign(corH, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                                cov2cor(stan::model::rvalue(H, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "H"), pstream__), 
                                "assigning variable corH");
                    current_statement_begin__ = 263;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                multi_normal_log(stan::model::rvalue(rts, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rts"), stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "mu"), stan::model::rvalue(H, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "H")), 
                                "assigning variable log_lik");
                }
            } else if (as_bool(logical_eq(distribution, 1))) {
                current_statement_begin__ = 266;
                for (int t = 1; t <= T; ++t) {
                    current_statement_begin__ = 267;
                    stan::model::assign(rts_out, 
                                stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                multi_student_t_rng(nu, stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "mu"), stan::model::rvalue(H, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "H"), base_rng__), 
                                "assigning variable rts_out");
                    current_statement_begin__ = 268;
                    stan::model::assign(corH, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                                cov2cor(stan::model::rvalue(H, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "H"), pstream__), 
                                "assigning variable corH");
                    current_statement_begin__ = 269;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                multi_student_t_log(stan::model::rvalue(rts, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rts"), nu, stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "mu"), stan::model::rvalue(H, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "H")), 
                                "assigning variable log_lik");
                }
            }
            // validate, write generated quantities
            current_statement_begin__ = 252;
            size_t rts_out_j_2_max__ = T;
            size_t rts_out_j_1_max__ = nt;
            for (size_t j_2__ = 0; j_2__ < rts_out_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < rts_out_j_1_max__; ++j_1__) {
                    vars__.push_back(rts_out(j_1__, j_2__));
                }
            }
            current_statement_begin__ = 253;
            size_t log_lik_k_0_max__ = T;
            for (size_t k_0__ = 0; k_0__ < log_lik_k_0_max__; ++k_0__) {
                vars__.push_back(log_lik[k_0__]);
            }
            current_statement_begin__ = 254;
            size_t corH_i_0_max__ = T;
            for (size_t i_0__ = 0; i_0__ < corH_i_0_max__; ++i_0__) {
                stan::math::check_corr_matrix(function__, "corH[i_0__]", corH[i_0__]);
            }
            size_t corH_j_2_max__ = nt;
            size_t corH_j_1_max__ = nt;
            size_t corH_k_0_max__ = T;
            for (size_t j_2__ = 0; j_2__ < corH_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < corH_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < corH_k_0_max__; ++k_0__) {
                        vars__.push_back(corH[k_0__](j_1__, j_2__));
                    }
                }
            }
            current_statement_begin__ = 255;
            check_greater_or_equal(function__, "c_h_var", c_h_var, 0);
            size_t c_h_var_j_1_max__ = nt;
            for (size_t j_1__ = 0; j_1__ < c_h_var_j_1_max__; ++j_1__) {
                vars__.push_back(c_h_var(j_1__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_CCCMGARCH";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t phi0_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < phi0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t phi_j_2_max__ = nt;
        size_t phi_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < phi_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "phi" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t theta_j_2_max__ = nt;
        size_t theta_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < theta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t beta_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t c_h_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < c_h_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "c_h" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t a_h_simplex_j_1_max__ = Q;
        size_t a_h_simplex_k_0_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < a_h_simplex_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < a_h_simplex_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "a_h_simplex" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t a_h_sum_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < a_h_sum_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "a_h_sum" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t b_h_simplex_j_1_max__ = P;
        size_t b_h_simplex_k_0_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < b_h_simplex_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < b_h_simplex_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b_h_simplex" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t b_h_sum_s_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < b_h_sum_s_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b_h_sum_s" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t R_j_2_max__ = nt;
        size_t R_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < R_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < R_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "R" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t D1_init_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < D1_init_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "D1_init" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "nu";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t H_j_2_max__ = nt;
            size_t H_j_1_max__ = nt;
            size_t H_k_0_max__ = T;
            for (size_t j_2__ = 0; j_2__ < H_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < H_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < H_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "H" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t rr_j_1_max__ = nt;
            size_t rr_k_0_max__ = (T - 1);
            for (size_t j_1__ = 0; j_1__ < rr_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < rr_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "rr" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t mu_j_1_max__ = nt;
            size_t mu_k_0_max__ = T;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < mu_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "mu" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t D_j_1_max__ = nt;
            size_t D_k_0_max__ = T;
            for (size_t j_1__ = 0; j_1__ < D_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < D_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "D" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t vd_k_0_max__ = nt;
            for (size_t k_0__ = 0; k_0__ < vd_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "vd" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t ma_d_k_0_max__ = nt;
            for (size_t k_0__ = 0; k_0__ < ma_d_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ma_d" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t ar_d_k_0_max__ = nt;
            for (size_t k_0__ = 0; k_0__ < ar_d_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ar_d" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t a_h_j_1_max__ = nt;
            size_t a_h_k_0_max__ = Q;
            for (size_t j_1__ = 0; j_1__ < a_h_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < a_h_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "a_h" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t UPs_j_1_max__ = nt;
            for (size_t j_1__ = 0; j_1__ < UPs_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "UPs" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t ULs_j_1_max__ = nt;
            for (size_t j_1__ = 0; j_1__ < ULs_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ULs" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t b_h_j_1_max__ = nt;
            size_t b_h_k_0_max__ = P;
            for (size_t j_1__ = 0; j_1__ < b_h_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < b_h_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "b_h" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__) return;
        size_t rts_out_j_2_max__ = T;
        size_t rts_out_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < rts_out_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < rts_out_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rts_out" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t log_lik_k_0_max__ = T;
        for (size_t k_0__ = 0; k_0__ < log_lik_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t corH_j_2_max__ = nt;
        size_t corH_j_1_max__ = nt;
        size_t corH_k_0_max__ = T;
        for (size_t j_2__ = 0; j_2__ < corH_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < corH_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < corH_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "corH" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        size_t c_h_var_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < c_h_var_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "c_h_var" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t phi0_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < phi0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t phi_j_2_max__ = nt;
        size_t phi_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < phi_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "phi" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t theta_j_2_max__ = nt;
        size_t theta_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < theta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t beta_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t c_h_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < c_h_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "c_h" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t a_h_simplex_j_1_max__ = (Q - 1);
        size_t a_h_simplex_k_0_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < a_h_simplex_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < a_h_simplex_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "a_h_simplex" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t a_h_sum_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < a_h_sum_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "a_h_sum" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t b_h_simplex_j_1_max__ = (P - 1);
        size_t b_h_simplex_k_0_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < b_h_simplex_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < b_h_simplex_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b_h_simplex" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t b_h_sum_s_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < b_h_sum_s_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b_h_sum_s" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t R_j_1_max__ = ((nt * (nt - 1)) / 2);
        for (size_t j_1__ = 0; j_1__ < R_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "R" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t D1_init_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < D1_init_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "D1_init" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "nu";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t H_j_1_max__ = (nt + ((nt * (nt - 1)) / 2));
            size_t H_k_0_max__ = T;
            for (size_t j_1__ = 0; j_1__ < H_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < H_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "H" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t rr_j_1_max__ = nt;
            size_t rr_k_0_max__ = (T - 1);
            for (size_t j_1__ = 0; j_1__ < rr_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < rr_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "rr" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t mu_j_1_max__ = nt;
            size_t mu_k_0_max__ = T;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < mu_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "mu" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t D_j_1_max__ = nt;
            size_t D_k_0_max__ = T;
            for (size_t j_1__ = 0; j_1__ < D_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < D_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "D" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t vd_k_0_max__ = nt;
            for (size_t k_0__ = 0; k_0__ < vd_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "vd" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t ma_d_k_0_max__ = nt;
            for (size_t k_0__ = 0; k_0__ < ma_d_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ma_d" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t ar_d_k_0_max__ = nt;
            for (size_t k_0__ = 0; k_0__ < ar_d_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ar_d" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t a_h_j_1_max__ = nt;
            size_t a_h_k_0_max__ = Q;
            for (size_t j_1__ = 0; j_1__ < a_h_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < a_h_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "a_h" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t UPs_j_1_max__ = nt;
            for (size_t j_1__ = 0; j_1__ < UPs_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "UPs" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t ULs_j_1_max__ = nt;
            for (size_t j_1__ = 0; j_1__ < ULs_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ULs" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t b_h_j_1_max__ = nt;
            size_t b_h_k_0_max__ = P;
            for (size_t j_1__ = 0; j_1__ < b_h_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < b_h_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "b_h" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__) return;
        size_t rts_out_j_2_max__ = T;
        size_t rts_out_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < rts_out_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < rts_out_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rts_out" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t log_lik_k_0_max__ = T;
        for (size_t k_0__ = 0; k_0__ < log_lik_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t corH_j_1_max__ = ((nt * (nt - 1)) / 2);
        size_t corH_k_0_max__ = T;
        for (size_t j_1__ = 0; j_1__ < corH_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < corH_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "corH" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t c_h_var_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < c_h_var_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "c_h_var" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_CCCMGARCH_namespace::model_CCCMGARCH stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
