% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/softwarelogs4.R
\docType{data}
\name{softwarelogs4}
\alias{softwarelogs4}
\title{softwarelogs Bayesian Networks}
\format{
A discrete Bayesian network to discover poor performance indicators in a system and to explore usage patterns that usually require temporal analysis. The networks are given in the referenced paper. The vertices are:
\describe{
\item{load_time}{(high, low, medium, optimal);}
\item{language}{(bg, ca, cw, de, en, es, eu, fr, gl, it, jwe content encryption algorithms, jwe key management algorithms, jws signature algorithms, nl, pl, pt, ru, sr, unknown, zh);}
\item{user}{(high, low, medium, optimal);}
\item{page}{(high, low, medium, very low);}
\item{action}{(A128KW, A192GCM, ES256, SunJCE version 1.8, bad capthca, bad email, bad recapthca, bonus, bonus introduced is not a number, cancelBid, contract-sponsor, correctBPIOL, create, create division, create offer, createLeague, createLeagues, cronDiariom cronDiarioAuto, cronEVO, cronJorunada, cronJornadaAuto, cronSemanaAuto, cronTemporada, deleteAccount, deleteMessage, edit, fire player, fire trainer, hire trainer, load market page, load page, load round, logout, pay bonus, prepare team, publish a suggestion, redirect, search player, search top players, sendNotice, set new password, successful-search-players, successful bid, successfully send invitation, successfully create account, tried to create an offer, unsuccessful-search-players, unsuccessful bid-already invested, unsuccessful bid-amount too low, unsuccessful bid-less than initial price, unsuccessful bid-negative amount, unsuccessful bid-not enough available money, unsuccessuful bid-wrong number format, update account, updateRatingList, username in use, wrongcaptcha send invitation);}
\item{day}{(Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday);}
\item{action_duration}{(high, low, medium, optimal);}
\item{time_on_page}{(high, medium, low, very low);}
\item{num_petitions}{(1-3, 3-6, 6-59);}
\item{country}{(Argentina, Austria, Belgium, Canada, China, Czechia, France, Germany, Italy, Mexico, Peru, Portugal, Russia, Saudi Arabia, Slovakia, Spain, Turkey, Uganda, Ukraine, United Arab Emirates, United States, unknown, Venezuela);}
\item{browser}{(Mozilla, not set, Android Webview, Chrome, Edge, Firefox, Opera, Safari, Safari in-app, Samsung Internet, UC Browser, unknown);}
\item{device}{(desktop, mobile, tablet, unknown);}
\item{num_errors}{(high, low, medium, none);}
\item{user_type}{(ocasional, regular, very active);}
}
}
\value{
An object of class \code{bn.fit}. Refer to the documentation of \code{bnlearn} for details.
}
\description{
Bayesian Network analysis of software logs for data‐driven software maintenance.
}
\references{
del Rey, S., Martinez-Fernandez, S., & Salmeron, A. (2023). Bayesian Network analysis of software logs for data-driven software maintenance. IET Software, 17(3), 268-286.
}
