% Generated by roxygen2 (4.0.1): do not edit by hand
\name{boolprof}
\alias{boolprof}
\title{Calculate estimated likelihood-profiles.}
\usage{
boolprof(obj, method = names(obj$model.fit)[1], vars = 1:obj$k, k = 50,
  as.table = TRUE, scales = list(x = list(relation = "free")),
  between = list(x = 1, y = 1), main = "Estimated likelihood profiles",
  xlab = "beta", ylab = "Log-likelihood", ...)
}
\arguments{
\item{obj}{object of \code{boolean-class} containing a fit boolean model.}

\item{method}{estimation method to use}

\item{vars}{numeric vector selecting a set of covariates from the fitted
model}

\item{k}{integer indicating the number of points at which the
log-likelihood should be calculated.}

\item{as.table}{logical (default \code{TRUE}), to be passed to
\code{xyplot}.}

\item{scales}{list of settings for the scales argument passed to
\code{xyplot}.}

\item{between}{numeric specifying the space between panels.}

\item{main}{string, plot title}

\item{xlab}{string, the \code{x}-axis label.}

\item{ylab}{string, the \code{y}-axis label.}

\item{...}{Additional arguments to pass to \code{\link{xyplot}}. See that
cumentation for details.}
}
\value{
Returns an object of \code{\link{boolprof-class}}, the default
action being to present the default plot.
}
\description{
This function calculates log-likelihood profiles for the selected
variables. Despite the function name, these are not true profile likelihoods
as they hold all other coefficients fixed at their MLE.
}
\examples{
\dontrun{

## Note: This example assumes a boolean model has already been fit.

## Display the contours of the likelihood given a change the value of
## the coefficients.
(prof <- boolprof(fit))

## Extract the plots for x1_a and x4_b.
plot(prof, y = c("x1_a", "x4_b"))
plot(prof, y = c(1, 3), scales = list(y = list(relation = "free")))

## You can also use variable or index matching with boolprof to select
## particular covariates of interest.
boolprof(fit, vars = c(1, 3))
boolprof(fit, vars = c("x1_a", "x4_b"))
}
}
\author{
Jason W. Morgan (\email{morgan.746@osu.edu})
}

