% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filters}
\alias{filters}
\alias{daubechies_scaling_filter}
\alias{daubechies_wavelet_filter}
\title{Filters}
\usage{
daubechies_scaling_filter(order)

daubechies_wavelet_filter(order)
}
\arguments{
\item{order}{An integer specifying the order of the Daubechies filter (must be between 1 and 19).}
}
\value{
A numeric vector of size 2*order containing the filter coefficients.
}
\description{
Functions to compute Daubechies wavelet and scaling filters.
}
\examples{
# Daubechies Scaling Filter of order 4
daubechies_scaling_filter(4)
# Daubechies Wavelet Filter of order 4
daubechies_wavelet_filter(4)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/daubechies_filters.html}{Boost Documentation} for more details on the mathematical background.
}
