% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.lnOR.R
\name{boot.lnOR}
\alias{boot.lnOR}
\title{Natural-Logarithm-Transformed Odds Ratio (lnOR): Bootstrap-based Heterogeneity Test for Between-study Heterogeneity in Random- or Mixed- Effects Model}
\source{
Silagy  C, Lancaster  T, Stead  LF, Mant  D, Fowler  G. (2004). Nicotine replacement therapy for smoking cessation. Cochrane Database of Systematic Reviews 2004, Issue 3. Art. No.: CD000146. DOI: 10.1002/14651858.CD000146.pub2.
}
\usage{
boot.lnOR(
  n_00,
  n_01,
  n_10,
  n_11,
  lambda = 0,
  model = "random",
  mods = NULL,
  nrep = 10^4,
  p_cut = 0.05,
  boot.include = FALSE,
  parallel = FALSE,
  cores = 4,
  verbose = FALSE
)
}
\arguments{
\item{n_00}{A vector of number of participants who score negatively on both Y1 and Y2 (e.g., mortality cases in the control group).}

\item{n_01}{A vector of number of participants who score negatively on Y1 and positively on Y2  (e.g., recovery cases in the control group).}

\item{n_10}{A vector of number of participants who score positively on Y1 and negatively on Y2 (e.g., mortality cases in the experimental group).}

\item{n_11}{A vector of number of participants who score positively on both Y1 and Y2 (e.g., recovery cases in the experimental group).}

\item{lambda}{Size of the magnitude to be tested in the alternative hypothesis of the heterogeneity magnitude test. Default to 0.}

\item{model}{Choice of random- or mixed- effects models. Can only be set to \code{"random"}, or \code{"mixed"}.}

\item{mods}{Optional argument to include moderators in the model. \code{mods} is NULL for random-effects model and a dataframe of moderators for mixed-effects model. A single moderator can be given as a vector specifying the values of the moderator. Multiple moderators are specified by giving a matrix with as many columns as there are moderator variables. See \code{\link[metafor:rma.uni]{rma}} for more details.}

\item{nrep}{Number of replications used in bootstrap simulations. Default to 10^4.}

\item{p_cut}{Cutoff for p-value, which is the alpha level. Default to 0.05.}

\item{boot.include}{If true, bootstrap simulation results are included in the output (e.g., bootstrap critical values).}

\item{parallel}{If true, parallel computing using 4 cores will be performed during bootstrapping stage. Otherwise, for loop is used.}

\item{cores}{The number of cores used in the parallel computing. Default to 4.}

\item{verbose}{If true, show the progress of bootstrapping.}

\item{lnOR}{A vector of natural-logarithm-transformed odds ratio in the included studies, which is calculated as ln(n11*n00/n01/n10)}
}
\value{
A dataframe that contains the test statistics ('stat'), p-values ('p_value'), and significances of effect size heterogeneity ("Heterogeneity").
}
\description{
\code{boot.lnOR} returns the bootstrap-based tests of the residual heterogeneity in random- or mixed- effects model of natural-logarithm-transformed observed odds ratio (lnOR).
}
\details{
For odds ratio, its standard error will be infinite if any one of the four cells in the contingency tables is zero. In this case, Haldane and Anscombe correction is used by adding 0.5 to each cell value (Anscombe, 1956; Haldane, 1940).
This function returns the test statistics as well as their p-value and significances using (1) Q-test and (2) Bootstrap-based Heterogeneity Test with Restricted Maximum Likelihood (REML).

The results of significances are classified as "sig" or "n.s" based on the cutoff p-value (i.e., alpha level). "sig" means that the between-study heterogeneity is significantly different from zero whereas "n.s" means the between-study heterogeneity is not significantly different from zero. The default alpha level is 0.05.
}
\examples{
# A meta-analysis consists of 26 studies on nicotine replacement therapy for smoking cessation
library(HSAUR3)
data(smoking)

# Y1: receive treatment; Y2: stop smoking
n_00 <- smoking$tc - smoking$qc  # not receive treatement yet not stop smoking
n_01 <- smoking$qc # not receive treatement but stop smoking
n_10 <- smoking$tt - smoking$qt # receive treatement but not stop smoking
n_11 <- smoking$qt # receive treatement and stop smoking
lnOR <- log(n_11*n_00/n_01/n_10)

\dontrun{
boot.run <- boot.lnOR(n_00, n_01, n_10, n_11, model = 'random', p_cut = 0.05)
}
}
\references{
Anscombe, F. J. (1956). On estimating binomial response relations. Biometrika, 43(3/4), 461–464.

Haldane, J. (1940). The mean and variance of| chi 2, when used as a test of homogeneity, when expectations are small. Biometrika, 31(3/4), 346–355.

Viechtbauer, W. (2010). Conducting meta-analyses in R with the metafor package. Journal of Statistical Software, 36(3), 1-48. URL: http://www.jstatsoft.org/v36/i03/
}
