% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjustPrevalence.R
\name{adjPrevSensSpec}
\alias{adjPrevSensSpec}
\title{Adjust a prevalence point estimate for a given assay sensitivity and specificity.}
\usage{
adjPrevSensSpec(prevEst, sens, spec, replaceImpossibleValues = FALSE)
}
\arguments{
\item{prevEst}{The reported prevalence point estimate.}

\item{sens}{The known assay sensitivity.}

\item{spec}{The known assay specificity.}

\item{replaceImpossibleValues}{Logical; not all combinations of prevalence, sensitivity and specificity are possible and it can be that the adjusted prevalence is <0 or >1, so if this parameter is set to TRUE, values below 0 are set to 0 and values above 1 are set to 1.}
}
\value{
A vector of the same length as prevEst, returning the adjusted prevalence estimates.
}
\description{
Given a reported prevalence estimate from an imperfect assay with known sensitivity and specificity, this function will adjust the prevalence point estimate for the assay sensitivity and specificity.
}
\examples{
adjPrevSensSpec(prevEst=0.16,sens=0.90,spec=0.95)

}
\seealso{
\code{\link{adjPrevSensSpecCI}}, \code{\link{ssBetaPars}}, \code{\link{optim}}, \code{\link{dbeta}}
}
