% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{simScen2}
\alias{simScen2}
\title{Simulation scenario 2.}
\usage{
simScen2(B = 1000, p, sens, spec, nExp, nExpSens, nExpSpec, alpha = 0.05)
}
\arguments{
\item{B}{The number of simulations to run. Defaults to 1e3.}

\item{p}{The true value of the prevalence parameter.}

\item{sens}{The true value of the assay sensitivity parameter.}

\item{spec}{The true value of the assay specificity parameter}

\item{nExp}{The size of each simulated experiment to estimate \code{p}.}

\item{nExpSens}{The size of each simulated experiment to estimate \code{sens}.}

\item{nExpSpec}{The size of each simulated experiment to estimate \code{spec}.}

\item{alpha}{The confidence level; i.e. the desired coverage is 1-alpha. Defaults to 0.05.}
}
\value{
A list with 2 elements:
   \code{estimate} A single number, the proportion of simulations for which the confidence interval contained the true prevalence parameter value.
   \code{conf.int} A 95% confidence interval for the coverage estimate.
}
\description{
This is a simulation to compute the coverage of the confidence interval returned by bootComb() in the case of adjusting a prevalence estimate for estimates of sensitivity and specificity.
}
\examples{
\donttest{
simScen2(p=0.15,sens=0.90,spec=0.95,nExp=250,nExpSens=1000,nExpSpec=500,B=100)
  # B value only for convenience here
  # Increase B to 1e3 or 1e4 (be aware this may run for some time).
 }

}
