% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moc_data_loader.R
\name{load_moc_datasets}
\alias{load_moc_datasets}
\title{Load Multiple-Objective Clustering (MOC) Datasets}
\usage{
load_moc_datasets(data_dir = getwd())
}
\arguments{
\item{data_dir}{Directory containing the CSV datasets (default: current working directory)}
}
\value{
A list containing:
\describe{
  \item{datasets}{Named list of processed datasets}
}
}
\description{
Loads and processes datasets for multiple-objective clustering analysis.
The function loads CSV files from a specified directory and processes them by removing
NA columns.
}
\examples{
\dontrun{
# Load datasets
result <- load_moc_datasets("path/to/MOC_Data")

# Access a specific dataset
spiral <- result$datasets$Spiral
}

}
