% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Educational_Attainment}
\alias{Educational_Attainment}
\title{Educational_Attainment
This data-set is based on National Longitudinal Study Youth (NLSY, 1979) survey data.
The data is used to analyze the study returns to schooling.}
\usage{
data(Educational_Attainment)
}
\value{
Returns data with components
\itemize{
\item{\code{BG_14_female_work}: }{Indicator for working female at age of 14.}
\item{\code{BG_14_urban}: }{Indicator for the youth living in urban are at age of 14.}
\item{\code{BG_14_region_south}: }{Indicator for the youth living in South at age of 14.}
\item{\code{BG_edu_father}: }{Individual's father education.}
\item{\code{BG_edu_mother}: }{Individual's mother education.}
\item{\code{BG_fam_income}: }{Family income of the household.}
\item{\code{female}: }{Indicator for Individuals gender.}
\item{\code{race_black}: }{Race of the individual is white.}
\item{\code{age_15}: }{Indicator for age of 15.}
\item{\code{age_16}: }{Indicator for age of 16.}
\item{\code{age_17}: }{Indicator for age of 17.}
\item{\code{dep_edu_level}: }{a matrix of ordinal outcomes.}
}
}
\description{
Educational_Attainment
This data-set is based on National Longitudinal Study Youth (NLSY, 1979) survey data.
The data is used to analyze the study returns to schooling.
}
\details{
This sub-sample from NLSY data-set here includes 3,923 individuals only. The sub-sample
is based on the cohorts aged 14-17 in 1979. The dependent variable i.e. the educational
degree, has four categories given as \emph{less than high school, high school degree, some
college or associate's degree} and \emph{college or graduate degree}.
The sample has 897 (22.87\%), 1392 (35.48\%), 876 (22.33\%) and 758 (19.32\%) observations in
respectively in each category.
}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24.

Jeliazkov, I., Graves, J., and Kutzbach, M. (2008). “Fitting and Comparison of Models
for Multivariate Ordinal Outcomes.” Advances in Econometrics: Bayesian Econometrics, 23: 115–156.
}
\seealso{
\href{https://www.bls.gov/nls/}{NLSY}, \href{https://www.bls.gov/nls/nlsy97.htm}{Survey Process}.
}
\keyword{datasets}
