% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORI.R
\name{quantreg_or1}
\alias{quantreg_or1}
\title{Bayesian quantile regression for ordinal quantile model
with more than 3 outcomes}
\usage{
quantreg_or1(y, x, b0, B0, d0, D0, mcmc, p, tune, display)
}
\arguments{
\item{y}{observed ordinal outcomes, column vector of dimension \eqn{(n x 1)}.}

\item{x}{covariate matrix of dimension \eqn{(n x k)} including a column of ones with or without column names.}

\item{b0}{prior mean for normal distribution to sample \eqn{\beta}, default is 0.}

\item{B0}{prior variance for normal distribution to sample \eqn{\beta}.}

\item{d0}{prior mean of normal distribution to sample \eqn{\delta}, default is 0.}

\item{D0}{prior variance for normal distribution to sample \eqn{\delta}.}

\item{mcmc}{number of MCMC iterations, post burn-in.}

\item{p}{quantile level or skewness parameter, p in (0,1).}

\item{tune}{tuning parameter to adjust MH acceptance rate.}

\item{display}{whether to print the final output or not, default is TRUE.}
}
\value{
Returns a list with components:
\itemize{
\item{\code{postMeanbeta}: }{vector with mean of sampled
 \eqn{\beta} for each covariate.}
 \item{\code{postMeandelta}: }{vector with mean of sampled
 \eqn{\delta} for each cut point.}
 \item{\code{postStdbeta}: }{vector with standard deviation
 of sampled \eqn{\beta} for each covariate.}
 \item{\code{postStddelta}: }{vector with standard deviation
 of sampled \eqn{\delta} for each cut point.}
 \item{\code{gamma}: }{vector of cut points including Inf and
 -Inf.}
 \item{\code{catt}}
 \item{\code{acceptancerate}: }{scalar to judge the acceptance
 rate of samples.}
 \item{\code{allQuantDIC}: }{results of the DIC criteria.}
 \item{\code{logMargLikelihood}: }{scalar value for log marginal likelihood.}
 \item{\code{beta}: }{matrix with all sampled values for \eqn{\beta}.}
 \item{\code{delta}: }{matrix with all sampled values for \eqn{\delta}.}
}
}
\description{
This function estimates Bayesian quantile regression for ordinal quantile model with
more than 3 outcomes and reports the posterior mean, posterior standard deviation, and 95
percent posterior credible intervals of \eqn{(\beta, \delta)}.
}
\details{
Function implements the Bayesian quantile regression for
ordinal model with more than 3 outcomes using a combination of Gibbs sampling
and Metropolis-Hastings algorithm.

Function initializes prior and then iteratively
samples \eqn{\beta}, \eqn{\delta} and latent variable z.
Burn-in is taken as \eqn{0.25*mcmc} and \eqn{nsim = burn}-\eqn{in + mcmc}.
}
\examples{
 set.seed(101)
 data("data25j4")
 x <- data25j4$x
 y <- data25j4$y
 k <- dim(x)[2]
 J <- dim(as.array(unique(y)))[1]
 D0 <- 0.25*diag(J - 2)
 output <- quantreg_or1(y = y,x = x, B0 = 10*diag(k), D0 = D0,
 mcmc = 40, p = 0.25, tune = 1)


 # Number of burn-in draws: 10
 # Number of retained draws: 40
 # Summary of MCMC draws:


 #             Post Mean  Post Std   Upper Credible Lower Credible
 # beta_0       -2.6202   0.3588        -2.0560        -3.3243
 # beta_1        3.1670   0.5894         4.1713         2.1423
 # beta_2        4.2800   0.9141         5.7142         2.8625
 # delta_1       0.2188   0.4043         0.6541        -0.4384
 # delta_2       0.4567   0.3055         0.7518        -0.2234

 # MH acceptance rate: 36
 # Log of Marginal Likelihood: -554.61
 # DIC: 1375.33

}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24. DOI: 10.1214/15-BA939

Yu, K., and Moyeed, R. A. (2001). “Bayesian Quantile Regression.” Statistics and
Probability Letters, 54(4): 437–447. DOI: 10.12691/ajams-6-6-4

Casella, G., and George, E. I. (1992). “Explaining the Gibbs Sampler.”
The American Statistician, 46(3): 167-174. DOI: 10.1080/00031305.1992.10475878

Geman, S., and Geman, D. (1984). “Stochastic Relaxation,
Gibbs Distributions, and the Bayesian Restoration of Images.”
IEEE Transactions an Pattern Analysis and Machine Intelligence,
6(6): 721-741. DOI:10.1109/TPAMI.1984.4767596

Chib, S., and Greenberg, E. (1995). “Understanding the Metropolis-Hastings
Algorithm.” The American Statistician, 49(4): 327-335. DOI: 10.2307/2684568

Hastings, W. K. (1970). “Monte Carlo Sampling Methods Using
Markov Chains and Their Applications.” Biometrika, 57: 1317-1340. DOI: 10.2307/1390766
}
\seealso{
tcltk, \link[stats]{rnorm}, \link[stats]{qnorm},
Gibbs sampler, Metropolis-Hastings algorithm
}
