% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permute_group.R
\name{brainGraph_permute}
\alias{brainGraph_permute}
\title{Permutation test for group difference of graph measures}
\usage{
brainGraph_permute(densities, resids, N = 5000, perms = NULL, auc = FALSE,
  level = c("graph", "vertex", "other"), measure = c("btwn.cent", "degree",
  "E.nodal", "ev.cent", "knn", "transitivity", "vulnerability"), atlas = NULL,
  .function = NULL)
}
\arguments{
\item{densities}{Numeric vector of graph densities}

\item{resids}{An object of class \code{brainGraph_resids} (the output from
\code{\link{get.resid}})}

\item{N}{Integer; the number of permutations (default: 5e3)}

\item{perms}{Numeric matrix of permutations, if you would like to provide
your own (default: \code{NULL})}

\item{auc}{Logical indicating whether or not to calculate differences in the
area-under-the-curve of metrics (default: \code{FALSE})}

\item{level}{A character string for the attribute "level" to calculate
differences (default: \code{graph})}

\item{measure}{A character string specifying the vertex-level metric to
calculate, only used if \code{level='vertex'} (default: \code{btwn.cent})}

\item{atlas}{Character string of the atlas name; required if
\code{level='graph'} (default: \code{NULL})}

\item{.function}{A custom function you can pass if \code{level='other'}}
}
\value{
An object of class \code{brainGraph_permute} with input arguments in
  addition to:
  \item{DT}{A data table with permutation statistics}
  \item{obs.diff}{A data table of the observed group differences}
  \item{groups}{Group names}
}
\description{
\code{brainGraph_permute} draws permutations from linear model residuals to
determine the significance of between-group differences of a global or
vertex-wise graph measure. It is intended for structural covariance networks
(in which there is only one graph per group), but can be extended to other
types of data.
}
\details{
If you would like to calculate differences in the area-under-the-curve (AUC)
across densities, then specify \code{auc=TRUE}.

There are three possible "levels":
\enumerate{
  \item \emph{graph} Calculate modularity (Louvain algorithm), clustering
  coefficient, characteristic path length, degree assortativity, global
  efficiency, lobe assortativity, and edge asymmetry.
  \item \emph{vertex} Choose one of: betweenness centrality, degree, nodal
  efficiency, k-nearest neighbor degree, transitivity, or vulnerability.
  \item \emph{other} Supply your own function. This is useful if you want to
  calculate something that I haven't hard-coded. It must take as its own
  arguments: \code{g} (a list of lists of \code{igraph} graph objects); and
  \code{densities} (numeric vector).
}
}
\examples{
\dontrun{
myResids <- get.resid(lhrh, covars)
myPerms <- shuffleSet(n=nrow(myResids$resids.all), nset=1e3)
out <- brainGraph_permute(densities, m, perms=myPerms, atlas='dk')
out <- brainGraph_permute(densities, m, perms=myPerms, level='vertex')
out <- brainGraph_permute(densities, m, perms=myPerms,
  level='other', .function=myFun)
}
}
\seealso{
Other Group analysis functions: \code{\link{IndividualContributions}},
  \code{\link{NBS}}, \code{\link{brainGraph_GLM}},
  \code{\link{brainGraph_boot}},
  \code{\link{brainGraph_mediate}}, \code{\link{mtpc}}

Other Structural covariance network functions: \code{\link{IndividualContributions}},
  \code{\link{brainGraph_boot}},
  \code{\link{brainGraph_init}}, \code{\link{corr.matrix}},
  \code{\link{get.resid}},
  \code{\link{plot.brainGraph_resids}},
  \code{\link{plot_volumetric}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
