% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_resid.R
\name{Residuals}
\alias{Residuals}
\alias{get.resid}
\alias{Extract.brainGraph_resids}
\alias{[.brainGraph_resids}
\alias{summary.brainGraph_resids}
\alias{plot.brainGraph_resids}
\title{Linear model residuals in structural covariance networks}
\usage{
get.resid(dt.vol, covars, method = c("comb.groups", "sep.groups"),
  use.mean = FALSE, exclude.cov = NULL, ...)

\method{[}{brainGraph_resids}(x, i, g = NULL)

\method{summary}{brainGraph_resids}(object, regions = NULL, ...)

\method{plot}{brainGraph_resids}(x, regions = NULL, cols = FALSE, ...)
}
\arguments{
\item{dt.vol}{A \code{data.table} containing all the volumetric measure of
interest (i.e., the object \code{lhrh} as ouptut by
\code{\link{import_scn}})}

\item{covars}{A \code{data.table} of the covariates of interest}

\item{method}{Character string indicating whether to test models for subject
groups separately or combined (default: \code{comb.groups})}

\item{use.mean}{Logical should we control for the mean hemispheric brain
value (e.g. mean LH/RH cortical thickness) (default: \code{FALSE})}

\item{exclude.cov}{Character vector of covariates to exclude (default:
\code{NULL})}

\item{...}{Arguments passed to \code{\link{brainGraph_GLM_design}} (optional)}

\item{x}{A \code{brainGraph_resids} object}

\item{i}{Numeric vector of the indices}

\item{g}{Character string indicating the group (default: \code{NULL})}

\item{object}{A \code{brainGraph_resids} object}

\item{regions}{Character vector of region(s) to focus on; default behavior is
to show summary for all regions}

\item{cols}{Logical indicating whether to color by group (default: FALSE)}
}
\value{
\code{get.resid} - an object of class \code{brainGraph_resids} with
  elements:
  \item{X}{The \emph{design matrix}}
  \item{method}{The input argument \code{method}}
  \item{use.mean}{The input argument \code{use.mean}}
  \item{all.dat.tidy}{The tidied \code{data.table} of volumetric data (e.g.,
    mean regional cortical thickness) and covariates, along with
    \emph{resids} column added}
  \item{resids.all}{The "wide" \code{data.table} of residuals}
  \item{groups}{Group names}

\code{\link{summary.brainGraph_resids}} returns a list with two
  data tables, one of the residuals, and one of only the outlier regions

The \code{plot} method returns a \emph{list} of
  \code{\link[ggplot2]{ggplot}} objects
}
\description{
\code{get.resid} runs linear models across brain regions listed in a
\code{data.table} (e.g. cortical thickness), adjusting for variables in
\code{covars} (e.g. age, sex, etc.), and calculates the
\emph{externally Studentized} (or \emph{leave-one-out}) residuals.

The \code{[} method will let you reorder or subset residuals based on a given
numeric vector. However, this is used in bootstrap and permutation analysis
and should generally not be called directly by the user.

The \code{summary} method prints the number of outliers per region, and the
number of times a given subject was an outlier (i.e., across regions).

The \code{plot} method lets you check the model residuals for each brain
region in a structural covariance analysis. It shows a \emph{qqplot} of the
studentized residuals, as output from \code{\link{get.resid}}.
}
\details{
You can choose to run models for each of your subject groups separately or
combined (the default) via the \code{method} argument. You may also choose
whether or not to include the mean, per-hemisphere structural measure in the
models. Finally, you can specify variables that are present in \code{covars}
but you would like to exclude from the models.
}
\examples{
\dontrun{
myresids <- get.resids(lhrh, covars)
residPlots <- plot(myresids, cols=TRUE)

## Save as a multi-page PDF
ml <- marrangeGrob(residPlots, nrow=3, ncol=3)
ggsave('residuals.pdf', ml)
}
}
\seealso{
\code{\link{rstudent}}

\code{\link[stats]{qqnorm}}

Other Structural covariance network functions: \code{\link{Bootstrapping}},
  \code{\link{IndividualContributions}},
  \code{\link{brainGraph_permute}},
  \code{\link{corr.matrix}}, \code{\link{import_scn}},
  \code{\link{plot_volumetric}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\concept{Structural covariance network functions}
