% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/break.R
\name{broken.lm}
\alias{broken.lm}
\title{Breaking Down of Model Predictions for lm models}
\usage{
\method{broken}{lm}(
  model,
  new_observation,
  ...,
  baseline = 0,
  predict.function = stats::predict.lm
)
}
\arguments{
\item{model}{a lm model}

\item{new_observation}{a new observation with columns that corresponds to variables used in the model}

\item{...}{other parameters}

\item{baseline}{the orgin/baseline for the breakDown plots, where the rectangles start. It may be a number or a character "Intercept". In the latter case the orgin will be set to model intercept.}

\item{predict.function}{function that will calculate predictions out of model (typically \code{predict} or \code{betas})}
}
\value{
an object of the broken class
}
\description{
Breaking Down of Model Predictions for lm models
}
\examples{
model <- lm(Sepal.Length~., data=iris)
new_observation <- iris[1,]
br <- broken(model, new_observation)
plot(br)

# works for interactions as well
model <- lm(Sepal.Length ~ Petal.Width*Species, data = iris)
summary(model)

new_observation <- iris[1,]
br <- broken(model, new_observation)
br
plot(br)

br2 <- broken(model, new_observation, predict.function = betas)
br2
plot(br2)
}
