% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_breathtest_excel.R
\name{read_breathtest_excel}
\alias{read_breathtest_excel}
\title{Reads breathtest data in Excel format}
\usage{
read_breathtest_excel(filename, sheet = 1)
}
\arguments{
\item{filename}{Name of Excel-file to be read}

\item{sheet}{Name or number of Excel file to be read. When used with 
\code{\link{read_any_breathtest}}, the first sheet is always read. You must 
call  \code{read_breathtest_excel} explicitly to read other worksheets, as shown
in the example below.}
}
\value{
Different from the other readXXX function, this returns a list
with a data frame, not a structure of \code{\link{breathtest_data}}. 
Pass result through \code{\link{cleanup_data}} to make it compatible with 
other formats.
}
\description{
Can read several formats of data sets in Excel, from
2 (\code{minute, pdr or dob} for 1 record) to 4 columns (\code{patient_id, 
group, minute, pdr or dob}). Conversion from dob to pdf is done for 
assuming 180 cm height and 75 kg weight.
See the example below with several sheets for supported formats
}
\examples{
filename = btcore_file("ExcelSamples.xlsx")
sheets = readxl::excel_sheets(filename)
# First 4 lines of each sheet
for (sheet in sheets) {
  cat("\nSheet ", sheet,"\n")
  ex = readxl::read_excel(filename, sheet = sheet, n_max = 4)
  print(ex)
}  
# To get consistently formatted data from a sheet
bt_data = read_breathtest_excel(filename, sheets[6])
# 3 columns
str(bt_data)
bt_cleaned = cleanup_data(bt_data)
# 4 columns standard format
str(bt_cleaned)
}
