% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/breathtestfit_broom.R
\name{tidy.breathtestfit}
\alias{tidy.breathtestfit}
\title{Broom-style tidying methods for breathtestfit}
\usage{
\method{tidy}{breathtestfit}(x, ...)
}
\arguments{
\item{x}{Object of class \code{breathttestfit}}

\item{...}{other parameters passed to methods}
}
\value{
A tibble/data frame with columns
\describe{
  \item{patient_id}{Patient Id (character)}
  \item{group}{Treatment or patient group (character)}
  \item{m}{Fraction metabolized}
  \item{k}{Time constant (1/minutes)}
  \item{beta}{The so-called lag parameters, no dimension}
  \item{t50}{Emptying half time in minutes as calculated following Maes/Ghoos}
}
}
\description{
Broom-method \code{\link[generics]{tidy}} to streamline the results of class 
\code{breathttestfit}  as generated by  \code{nls_fit} or \code{nlme_fit}. Returns 
the fit  coefficients and half-emptying time t50 with the Maes/Ghoos method; 
additional parameters should be extracted with \code{\link[=coef.breathtestfit]{coef}}.
}
\examples{
library(broom)
# Generate simulated data
data = cleanup_data(simulate_breathtest_data()$data)
# Fit with the population method
fit = nlme_fit(data)
# Output coefficients
tidy(fit)
# All coefficients in the long form
coef(fit)
}
\seealso{
\code{\link[generics]{tidy}}
}
