% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-show.R
\name{br_show_forest}
\alias{br_show_forest}
\title{Show a forest plot for regression results}
\usage{
br_show_forest(
  breg,
  clean = TRUE,
  rm_controls = FALSE,
  ...,
  subset = NULL,
  drop = NULL,
  tab_headers = NULL
)
}
\arguments{
\item{breg}{A regression object with results (must pass \code{assert_breg_obj_with_results()}).}

\item{clean}{Logical indicating whether to clean/condense redundant group/focal variable labels.
If \code{TRUE}, remove "Group" or "Focal" variable column when the values in the result table
are same (before performing \code{subset} and \code{drop}),
and reduce repeat values in column "Group", "Focal", and "Variable".}

\item{rm_controls}{If \code{TRUE}, remove control terms.}

\item{...}{Additional arguments passed to \code{forestploter::forest()}, run \code{vignette("forestploter-post", "forestploter")}
to see more plot options.}

\item{subset}{Expression for subsetting the results data (\code{br_get_results(breg)}).}

\item{drop}{Column indices to drop from the display table.}

\item{tab_headers}{Character vector of custom column headers (must match number of displayed columns).}
}
\value{
A plot
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This function takes regression results and formats them into a forest plot display. It handles:
\itemize{
\item Formatting of estimates, CIs and p-values
\item Automatic x-axis limits calculation
\item Cleaning of redundant group/focal variable labels
\item Custom subsetting and column dropping
The function uses \code{forestploter::forest()} internally for the actual plotting.
}
}
\examples{
m <- br_pipeline(mtcars,
  y = "mpg",
  x = colnames(mtcars)[2:4],
  x2 = "vs",
  method = "gaussian"
)
br_show_forest(m)
br_show_forest(m, clean = TRUE, drop = 3)
br_show_forest(m, clean = FALSE)
}
\seealso{
Other br_show: 
\code{\link{br_show_fitted_line}()},
\code{\link{br_show_fitted_line_2d}()},
\code{\link{br_show_forest_ggstats}()},
\code{\link{br_show_forest_ggstatsplot}()},
\code{\link{br_show_risk_network}()},
\code{\link{br_show_table}()},
\code{\link{br_show_table_gt}()}
}
\concept{br_show}
