% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspaces.R
\name{db_workspace_export}
\alias{db_workspace_export}
\title{Export Notebook or Directory (Workspaces)}
\usage{
db_workspace_export(
  path,
  format = c("AUTO", "SOURCE", "HTML", "JUPYTER", "DBC", "R_MARKDOWN"),
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{path}{Absolute path of the notebook or directory.}

\item{format}{One of \code{AUTO}, \code{SOURCE}, \code{HTML}, \code{JUPYTER}, \code{DBC}, \code{R_MARKDOWN}.
Default is \code{SOURCE}.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\value{
base64 encoded string
}
\description{
Export Notebook or Directory (Workspaces)
}
\details{
Export a notebook or contents of an entire directory. If path does not exist,
this call returns an error \code{RESOURCE_DOES_NOT_EXIST.}

You can export a directory only in \code{DBC} format. If the exported data exceeds
the size limit, this call returns an error \code{MAX_NOTEBOOK_SIZE_EXCEEDED.} This
API does not support exporting a library.

At this time we do not support the \code{direct_download} parameter and returns a
base64 encoded string.

\href{https://docs.databricks.com/dev-tools/api/latest/workspace.html#export}{See More}.
}
\seealso{
Other Workspace API: 
\code{\link{db_workspace_delete}()},
\code{\link{db_workspace_get_status}()},
\code{\link{db_workspace_import}()},
\code{\link{db_workspace_list}()},
\code{\link{db_workspace_mkdirs}()}
}
\concept{Workspace API}
