% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Landscape-Methods.R
\docType{methods}
\name{plot Landscape-class}
\alias{plot Landscape-class}
\alias{plot,Landscape,ANY-method}
\title{Plot Method for a Landscape-class}
\usage{
\S4method{plot}{Landscape,ANY}(x, y, add = F, objectT = NULL, time = -1,
  ..., plot.legend = TRUE, plot.legend.raster = TRUE)
}
\arguments{
\item{x}{A Landscape object}

\item{y}{ANY}

\item{add}{boolean to add draw hover plot}

\item{objectT}{Toxic intensity matrix (result of \link{toxicIntensity}, default NULL)}

\item{time}{Time selection (default = -1) for Toxic intensity}

\item{...}{default plot par}

\item{plot.legend}{plot legend (default TRUE)}

\item{plot.legend.raster}{plot raster legend (default TRUE)}
}
\description{
Plot a \link{Landscape} object.
If \code{time} and \code{objecT} (as ToxicIntensityRaster class attribut) is specified, the values of \code{objectT} at time \code{time} are draw over the landscape.
}
\examples{
\dontrun{
# plot a Landscape object
data(maize_65)
plot(maize.landscape)
# plot pollen dispersion at time 61 for maize data
## create a ToxicIntensityRaster object
tox<-array(0,c(61,1024,1024))
tox[61,,]<-as.matrix(maize.toxicintensity61)
attr(tox,"class") <- "ToxicIntensityRaster"
## plot tox over the landscape at time 61
plot(maize.landscape,objectT=tox,time=61)
}
}

