% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demo.R
\name{demo.pollen.run}
\alias{demo.pollen.run}
\alias{briskaR-demo}
\title{briskaR package pollen demonstration}
\usage{
demo.pollen.run(nb_fields=100,max_size=5000,raster_size=2^10,nb_ind=100)
}
\arguments{
\item{nb_fields}{number of fields (sources and neutrals) in the landscape (default 100)}

\item{max_size}{landscape size (in meter) (default 5000)}

\item{raster_size}{raster size (default 2^10)}

\item{nb_ind}{number of individuals to simulate (default 100)}
}
\value{
A list of the simulated \link{Landscape-class} object, the \link{Individuals-class} object, and the \link{toxicIntensity} array [time, x, y].
The map of landscape with toxic intensity and individual states is plotted at time 30 (end of simulation).
}
\description{
Demonstration of briskaR package on Bt maize pollen (Genetically Modified crop) on non target Lepidoptera larvae.
}
\details{
In this example, 40\% of fields are sources (40 fields) and 100 individuals are exposed to toxic pollen. The time simulation of this demo is 30 days. 

This demo takes about 2 minutes running, according to the computer.
}
\examples{
\dontrun{
# Demo for toxic pollen dispersion on (100) exposed individuals with 100 fields 
# in a squared domain of 5000x5000meters. 
# The domain is discretized by 1024x1024 pixels (2^10).
demo.pollen.run(nb_fields=100,max_size=5000,raster_size=2^10,nb_ind=100)
}
}
\keyword{demo}
\keyword{demo.pollen.run}
