% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecoToxic.R
\name{plotEcotoxic}
\alias{plotEcotoxic}
\alias{plotEcoToxic}
\title{Plot internal toxic concentration method}
\usage{
plotEcoToxic(objectL, objectI, objectT, numind = 1)
}
\arguments{
\item{objectL}{A \link{Landscape} object}

\item{objectI}{An \link{Individuals} object}

\item{objectT}{A ToxicIntensityRaster, a 3d array of Toxic intensity over the time [t,x,y], (first indice is time) see \code{\link{toxicIntensity}}}

\item{numind}{An individual ID}
}
\description{
Plot a time series of internal toxic concentration for a given individual.
}
\examples{
\dontrun{
data(maize_65)
# Simulate pollen dispersion
tox <- toxicIntensity(maize.landscape,maize.emitted_pollen,1,61)
# plot ecotoxicology of individual 1.
ind2<-ecoToxic(maize.landscape,maize.individuals,objectT=tox,maxtime=61)
plot(maize.landscape,ind2,objectT=tox,numind=1)
}
}
