% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R
\name{as.mcmc.brmsfit}
\alias{as.mcmc}
\alias{as.mcmc.brmsfit}
\title{Extract posterior samples for use with the \pkg{coda} package}
\usage{
\method{as.mcmc}{brmsfit}(x, pars = NA, exact_match = FALSE,
  inc_warmup = FALSE, ...)
}
\arguments{
\item{x}{An \code{R} object typically of class \code{brmsfit}}

\item{pars}{Names of parameters for which posterior samples 
should be returned, as given by a character vector or regular expressions.
By default, all posterior samples of all parameters are extracted}

\item{exact_match}{Indicates whether parameter names 
should be matched exactly or treated as regular expression. 
Default is \code{FALSE}.}

\item{inc_warmup}{Indicates if the warmup samples should be included.
Default is \code{FALSE}. Warmup samples are used to tune the 
parameters of the sampling algorithm and should not be analyzed.}

\item{...}{currently unused}
}
\value{
A \code{list} of \code{mcmc} objects (not an \code{mcmc} object itself).
}
\description{
Extract posterior samples for use with the \pkg{coda} package
}

