% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{Hurdle}
\alias{Hurdle}
\alias{dhurdle_poisson}
\alias{phurdle_poisson}
\alias{dhurdle_negbinomial}
\alias{phurdle_negbinomial}
\alias{dhurdle_gamma}
\alias{phurdle_gamma}
\alias{dhurdle_lognormal}
\alias{phurdle_lognormal}
\title{Hurdle Distributions}
\usage{
dhurdle_poisson(x, lambda, hu, log = FALSE)

phurdle_poisson(q, lambda, hu, lower.tail = TRUE, log.p = FALSE)

dhurdle_negbinomial(x, mu, shape, hu, log = FALSE)

phurdle_negbinomial(q, mu, shape, hu, lower.tail = TRUE, log.p = FALSE)

dhurdle_gamma(x, shape, scale, hu, log = FALSE)

phurdle_gamma(q, shape, scale, hu, lower.tail = TRUE, log.p = FALSE)

dhurdle_lognormal(x, mu, sigma, hu, log = FALSE)

phurdle_lognormal(q, mu, sigma, hu, lower.tail = TRUE, log.p = FALSE)
}
\arguments{
\item{x}{Vector of quantiles.}

\item{hu}{hurdle propability}

\item{log}{Logical; If \code{TRUE}, values are returned on the log scale.}

\item{q}{Vector of quantiles.}

\item{lower.tail}{Logical; If \code{TRUE} (default), return P(X <= x). 
Else, return P(X > x) .}

\item{log.p}{Logical; If \code{TRUE}, values are returned on the log scale.}

\item{mu, lambda}{location parameter}

\item{shape}{shape parameter}

\item{sigma, scale}{scale parameter}
}
\description{
Density and distribution functions for hurdle distributions.
}
\details{
The density of a hurdle distribution can be specified as follows.
If \eqn{x = 0} set \eqn{f(x) = \theta}. Else set
\eqn{f(x) = (1 - \theta) * g(x) / (1 - G(0))}
where \eqn{g(x)} and \eqn{G(x)} are the density and distribution
function of the non-hurdle part, respectively.
}
