% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcapply.R
\name{bcapply}
\alias{bcapply}
\alias{bcapply,ANY-method}
\title{Apply Function to Pair of Arrays with Broadcasting}
\usage{
bcapply(x, y, f, ...)

\S4method{bcapply}{ANY}(x, y, f, v = NULL)
}
\arguments{
\item{x, y}{conformable atomic or recursive vectors/arrays.}

\item{f}{a function that takes in exactly \bold{2} arguments,
and \bold{returns} a result
that can be stored in a single element of a recursive or atomic array.}

\item{...}{further arguments passed to or from methods. \cr \cr}

\item{v}{either \code{NULL}, or single string, giving the scalar type for a single iteration. \cr
If \code{NULL} (default) or \code{"list"}, the result will be a recursive array. \cr
If it is certain that, for every iteration,
\code{f()} always results in a \bold{single atomic scalar},
the user can specify the type in \code{v} to pre-allocate the result. \cr
Pre-allocating the results leads to slightly faster and more memory efficient code. \cr
NOTE: Incorrectly specifying \code{v} leads to undefined behaviour; \cr
when unsure, leave \code{v} at its default value.}
}
\value{
An atomic or recursive array with dimensions \code{bc_dim(x, y)}. \cr
Preserves some of the attributes of \code{x} and \code{y} similar to broadcasted infix operators,
as explained in \link{broadcast_operators}. \cr \cr
}
\description{
The \code{bcapply()} method
applies a function to 2 arrays element-wise with broadcasting. \cr
}
\examples{

x.dim <- c(5, 3, 2)
x.len <- prod(x.dim)

gen <- function(n) sample(list(letters, month.abb, 1:10), n, TRUE)

x <- array(gen(10), x.dim)
y <- array(1:5, c(5, 1, 1))

f <- function(x, y) strrep(x, y)
bcapply(x, y, f, v = "character")
}
