% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internals.R
\name{make_basis}
\alias{make_basis}
\title{Create linear splines basis}
\usage{
make_basis(
  x,
  xname = "x",
  internal = NULL,
  boundary = range(x),
  degree = 1L,
  warn = TRUE
)
}
\arguments{
\item{x}{numeric vector}

\item{xname}{predictor name. Default is \code{"x"}}

\item{internal}{a vector of internal knots, excluding boundary knots}

\item{boundary}{vector of external knots}

\item{degree}{the degree of the spline. The broken stick model
requires linear splines, so the default is \code{degree = 1}.
Setting \code{degree = 0} yields (crisp) dummy coding, and one
column less than for \code{degree = 1}.}

\item{warn}{a logical indicating whether warnings from \code{splines::bs()}
should be given.}
}
\value{
A matrix with \code{length(x)} rows and \code{length(breaks)}
columns, with some extra attributes described by \code{bs()}.
}
\description{
This function creates the basis function of a second-order (linear) splines
at a user-specific set of break points.
}
\note{
Before version 0.54, it was standard practice that the \code{knots}
array always included \code{boundary[1L]}.
}
\author{
Stef van Buuren, 2020
}
