% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeplot.R
\name{timeplot}
\alias{timeplot}
\title{Scatterplot with date/times on the x-axis}
\usage{
timeplot(x, y, ..., n = 5, scale = NULL, format = NULL)
}
\arguments{
\item{x}{X-axis coordinates of points for the plot (must be date/time values)}

\item{y}{Y-axis coordinates of points for the plot}

\item{...}{Optional graphics arguments passed to \code{\link[=grayplot]{grayplot()}}}

\item{n}{Approximate number of x-axis labels (passed to \code{\link[base:pretty]{base::pretty()}}).}

\item{scale}{Passed to \code{\link[=time_axis]{time_axis()}} for defining the x-axis labels}

\item{format}{Passed to \code{\link[=time_axis]{time_axis()}} for defining the x-axis labels}
}
\value{
None.
}
\description{
Like the \code{\link[=grayplot]{grayplot()}} function, but with the x-axis having date/times
}
\examples{
n <- 100
y <- rnorm(n)
x <- seq(as.POSIXct("2024-05-01 11:23"), as.POSIXct("2024-05-01 14:50"), length.out=n)
timeplot(x, y)
}
\seealso{
\code{\link[=time_axis]{time_axis()}}, \code{\link[=grayplot]{grayplot()}}, \code{\link[=dotplot]{dotplot()}}
}
