% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/matrix_tidiers.R
\name{matrix_tidiers}
\alias{glance.matrix}
\alias{matrix_tidiers}
\alias{tidy.matrix}
\title{Tidiers for matrix objects}
\usage{
\method{tidy}{matrix}(x, ...)

\method{glance}{matrix}(x, ...)
}
\arguments{
\item{x}{A matrix}

\item{...}{extra arguments, not used}
}
\value{
\code{tidy.matrix} returns the original matrix converted into
a data.frame, except that it incorporates rownames (if they exist)
into a column called \code{.rownames}.

\code{glance} returns a one-row data.frame with
  \item{nrow}{number of rows}
  \item{ncol}{number of columns}
  \item{complete.obs}{number of rows that have no missing values}
  \item{na.fraction}{fraction of values across all rows and columns that
  are missing}
}
\description{
These perform tidying operations on matrix objects. \code{tidy} turns the
matrix into a data.frame while bringing rownames, if they exist, in as
a column called \code{.rownames} (since results of tidying operations never
contain rownames). \code{glance} simply reports the number of rows and
columns. Note that no augment method exists for matrices.
}
\examples{
mat <- as.matrix(mtcars)
tidy(mat)
glance(mat)
}

