% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/nlme_tidiers.R
\name{nlme_tidiers}
\alias{augment.lme}
\alias{glance.lme}
\alias{nlme_tidiers}
\alias{tidy.lme}
\title{Tidying methods for mixed effects models}
\usage{
\method{tidy}{lme}(x, effects = "random", ...)

\method{augment}{lme}(x, data = x$data, newdata, ...)

\method{glance}{lme}(x, ...)
}
\arguments{
\item{x}{An object of class \code{lme}, such as those from \code{lme}
or \code{nlme}}

\item{effects}{Either "random" (default) or "fixed"}

\item{...}{extra arguments (not used)}

\item{data}{original data this was fitted on; if not given this will
attempt to be reconstructed}

\item{newdata}{new data to be used for prediction; optional}
}
\value{
All tidying methods return a \code{data.frame} without rownames.
The structure depends on the method chosen.

\code{tidy} returns one row for each estimated effect, either
random or fixed depending on the \code{effects} parameter. If
\code{effects = "random"}, it contains the columns
  \item{group}{the group within which the random effect is being estimated}
  \item{level}{level within group}
  \item{term}{term being estimated}
  \item{estimate}{estimated coefficient}

If \code{effects="fixed"}, \code{tidy} returns the columns
  \item{term}{fixed term being estimated}
  \item{estimate}{estimate of fixed effect}
  \item{std.error}{standard error}
  \item{statistic}{t-statistic}
  \item{p.value}{P-value computed from t-statistic}

\code{augment} returns one row for each original observation,
with columns (each prepended by a .) added. Included are the columns
  \item{.fitted}{predicted values}
  \item{.resid}{residuals}
  \item{.fixed}{predicted values with no random effects}

\code{glance} returns one row with the columns
  \item{sigma}{the square root of the estimated residual variance}
  \item{logLik}{the data's log-likelihood under the model}
  \item{AIC}{the Akaike Information Criterion}
  \item{BIC}{the Bayesian Information Criterion}
  \item{deviance}{returned as NA. To quote Brian Ripley on R-help:
 McCullagh & Nelder (1989) would be the authorative reference, but the 1982
first edition manages to use 'deviance' in three separate senses on one
page. }
}
\description{
These methods tidy the coefficients of mixed effects models
of the \code{lme} class from functions  of the \code{nlme} package.
}
\details{
When the modeling was performed with \code{na.action = "na.omit"}
(as is the typical default), rows with NA in the initial data are omitted
entirely from the augmented data frame. When the modeling was performed
with \code{na.action = "na.exclude"}, one should provide the original data
as a second argument, at which point the augmented data will contain those
rows (typically with NAs in place of the new columns). If the original data
is not provided to \code{augment} and \code{na.action = "na.exclude"}, a
warning is raised and the incomplete rows are dropped.
}
\examples{
if (require("nlme") & require("lme4")) {
    # example regressions are from lme4 documentation, but used for nlme
    lmm1 <- lme(Reaction ~ Days, random=~ Days|Subject, sleepstudy)
    tidy(lmm1)
    tidy(lmm1, effects = "fixed")
    head(augment(lmm1, sleepstudy))
    glance(lmm1)


    startvec <- c(Asym = 200, xmid = 725, scal = 350)
    nm1 <- nlme(circumference ~ SSlogis(age, Asym, xmid, scal),
                  data = Orange,
                  fixed = Asym + xmid + scal ~1,
                  random = Asym ~1,
                  start = startvec)
    tidy(nm1)
    tidy(nm1, effects = "fixed")
    head(augment(nm1, Orange))
    glance(nm1)
}
}
\seealso{
\link{na.action}
}

