% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brt.test.R
\name{brt.test}
\alias{brt.test}
\title{BRT test}
\usage{
brt.test(x, y, hi, lo = -hi, var.equal = T, log_pvalue = F)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{y}{a (non-empty) numeric vector of data values.}

\item{hi}{upper bound of the shift range (i.e. signficant if outside the range)}

\item{lo}{lower bound of the shift range (i.e. if hi=lo=0, return t.test)}

\item{var.equal}{a logical variable indicating whether to treat the two variances as being equal.If TRUE then the pooled variance is used to estimate the variance otherwise the Satterhwaite approximation to the degrees of freedom is used.}

\item{log_pvalue}{brt.value is returned in log scale.}
}
\description{
BRT test
}
\examples{
x=rnorm(10, 0, 1)
y=rnorm(10, 8, 2)
brt.test(x, y, hi=3)
}
