% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR_basic.R
\name{Print}
\alias{Print}
\alias{Glue}
\title{Print strings with rich formats and colors.}
\usage{
Print(...)

Glue(...)
}
\arguments{
\item{...}{Character strings enclosed by \code{"{ }"} will be evaluated as R code.

Character strings enclosed by \code{"<< >>"} will be printed as formatted and colored text.

Long strings are broken by line and concatenated together.

Leading whitespace and blank lines from the first and last lines are automatically trimmed.}
}
\value{
Formatted text.
}
\description{
Be frustrated with \code{print()} and \code{cat()}? Try \code{Print()}!
Run examples to see what it can do.
}
\details{
See more details in \code{\link[glue:glue]{glue::glue()}} and \code{\link[glue:glue]{glue::glue_col()}}.
}
\section{Functions}{
\itemize{
\item \code{Print}: Paste and print strings.

\item \code{Glue}: Paste strings.
}}

\examples{
name="Bruce"
Print("My name is <<underline <<bold {name}>>>>.
       <<bold <<blue Pi = {pi:.15}.>>>>
       <<italic <<green 1 + 1 = {1 + 1}.>>>>
       sqrt({x}) = <<red {sqrt(x):.3}>>", x=10)

}
