% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR_stats_05_advance.R
\name{PROCESS}
\alias{PROCESS}
\title{PROCESS for mediation and/or moderation analyses.}
\usage{
PROCESS(
  data,
  y = "",
  x = "",
  meds = c(),
  mods = c(),
  covs = c(),
  clusters = c(),
  hlm.re.m = "",
  hlm.re.y = "",
  hlm.type = c("1-1-1", "2-1-1", "2-2-1"),
  med.type = c("parallel", "serial"),
  mod.type = c("2-way", "3-way"),
  mod.path = c("x-y", "x-m", "m-y", "all"),
  cov.path = c("y", "m", "both"),
  mod1.val = NULL,
  mod2.val = NULL,
  ci = c("boot", "bc.boot", "bca.boot", "mcmc"),
  nsim = 100,
  seed = NULL,
  std = FALSE,
  digits = 3,
  nsmall = digits,
  file = NULL
)
}
\arguments{
\item{data}{Data frame.}

\item{y, x}{Variable name of outcome (Y) and predictor (X).

It supports both continuous (numeric) and dichotomous (factor) variables.}

\item{meds}{Variable name(s) of mediator(s) (M).
Use \code{c()} to combine multiple mediators.

It supports both continuous (numeric) and dichotomous (factor) variables.

It allows an infinite number of mediators in parallel
or 2~4 mediators in serial.

* Order matters when \code{med.type="serial"}
(PROCESS Model 6: serial mediation).}

\item{mods}{Variable name(s) of 0~2 moderator(s) (W).
Use \code{c()} to combine multiple moderators.

It supports all types of variables:
continuous (numeric), dichotomous (factor), and multicategorical (factor).

* Order matters when \code{mod.type="3-way"}
(PROCESS Models 3, 5.3, 11, 12, 18, 19, 72, and 73).

** Do not set this parameter when \code{med.type="serial"}
(PROCESS Model 6).}

\item{covs}{Variable name(s) of covariate(s) (i.e., control variables).
Use \code{c()} to combine multiple covariates.
It supports all types of (and an infinite number of) variables.}

\item{clusters}{HLM (multilevel) level-2 cluster(s):
e.g., \code{"School_ID"} or \code{c("Sub", "Item")}.}

\item{hlm.re.m, hlm.re.y}{HLM (multilevel) random effect term of M model and Y model.
By default, it converts \code{clusters} to \code{\link[lme4:lme4-package]{lme4}} syntax of random intercepts:
e.g., \code{"(1 | School_ID)"} or \code{"(1 | Sub) + (1 | Item)"}.
You can set these parameters to include more complex terms (e.g., random slopes).
In most cases, no need to set these parameters.}

\item{hlm.type}{HLM (multilevel) mediation type (levels of "X-M-Y"):
\code{"1-1-1"} (default),
\code{"2-1-1"} (indeed the same as \code{"1-1-1"} in a mixed model),
or \code{"2-2-1"} (currently \emph{not fully supported}, as limited by the \code{\link[mediation:mediate]{mediation}} package).
In most cases, no need to set this parameter.}

\item{med.type}{Type of mediator:
\code{"parallel"} (default) or \code{"serial"}
(only relevant to PROCESS Model 6).
Partial matches of \code{"p"} or \code{"s"} also work.
In most cases, no need to set this parameter.}

\item{mod.type}{Type of moderator:
\code{"2-way"} (default) or \code{"3-way"}
(relevant to PROCESS Models 3, 5.3, 11, 12, 18, 19, 72, and 73).
Partial matches of \code{"2"} or \code{"3"} also work.}

\item{mod.path}{Which path(s) do the moderator(s) influence?
\code{"x-y"}, \code{"x-m"}, \code{"m-y"}, or any combination of them
(use \code{c()} to combine), or \code{"all"} (i.e., all of them).
No default value.}

\item{cov.path}{Which path(s) do the control variable(s) influence?
\code{"y"}, \code{"m"}, or \code{"both"} (default).}

\item{mod1.val, mod2.val}{By default (\code{NULL}), it uses
\strong{Mean +/- SD} of a continuous moderator (numeric) or
\strong{all levels} of a dichotomous/multicategorical moderator (factor) to
perform simple slope analyses and/or conditional mediation analyses.
You may manually specify a vector of certain values: e.g.,
\code{mod1.val=c(1, 3, 5)} or \code{mod1.val=c("A", "B", "C")}.}

\item{ci}{Method for estimating the standard error (SE) and
95\% confidence interval (CI) of indirect effect(s).
Default is \code{"boot"} for (generalized) linear models or
\code{"mcmc"} for (generalized) linear mixed models (i.e., multilevel models).
\describe{
  \item{\code{"boot"}}{Percentile Bootstrap}
  \item{\code{"bc.boot"}}{Bias-Corrected Percentile Bootstrap}
  \item{\code{"bca.boot"}}{Bias-Corrected and Accelerated (BCa) Percentile Bootstrap}
  \item{\code{"mcmc"}}{Markov Chain Monte Carlo (Quasi-Bayesian)}
}
* Note that these methods \emph{never} apply to the estimates of simple slopes.
You \emph{should not} report the 95\% CIs of simple slopes as Bootstrap or Monte Carlo CIs,
because they are just standard CIs without any resampling method.}

\item{nsim}{Number of simulation samples (bootstrap resampling or Monte Carlo simulation)
for estimating SE and 95\% CI. Default is \code{100} for running examples faster.
In formal analyses, however, \strong{\code{nsim=1000} (or larger)} is strongly suggested!}

\item{seed}{Random seed for obtaining reproducible results.
Default is \code{NULL}.
You may set to any number you prefer
(e.g., \code{seed=5201314}, just an uncountable number).

* Note that all mediation models include random processes
(i.e., bootstrap resampling or Monte Carlo simulation).
To get exactly the same results between runs, you have to set a random seed.
However, even if you set the same seed number, it is unlikely to
get exactly the same results across different R packages
(e.g., \code{\link[lavaan:lavaan-class]{lavaan}} vs. \code{\link[mediation:mediate]{mediation}})
and software (e.g., SPSS, Mplus, R, jamovi).}

\item{std}{Standardized coefficients? Default is \code{FALSE}.
If \code{TRUE}, it will standardize all numeric (continuous) variables
before building regression models.
However, it is \emph{not suggested} to set \code{std=TRUE} for \emph{generalized} linear (mixed) models.}

\item{digits, nsmall}{Number of decimal places of output. Default is \code{3}.}

\item{file}{File name of MS Word (\code{.doc}).
Currently, only regression model summary can be saved.}
}
\value{
Invisibly return a list of results:
\describe{
  \item{\code{process.id}}{PROCESS model number.}
  \item{\code{process.type}}{PROCESS model type.}
  \item{\code{model.m}}{"Mediator" (M) models (a list of multiple models).}
  \item{\code{model.y}}{"Outcome" (Y) model.}
  \item{\code{results}}{Effect estimates and other results (unnamed list object).}
}
}
\description{
To perform mediation, moderation, and conditional process (moderated mediation) analyses,
people may use software like
\href{http://www.statmodel.com/index.shtml}{Mplus},
\href{https://www.processmacro.org/index.html}{SPSS "PROCESS" macro},
and \href{https://njrockwood.com/mlmed/}{SPSS "MLmed" macro}.
Some R packages can also perform such analyses separately and in a complex way, including
\link[mediation:mediate]{R package "mediation"},
\link[interactions:sim_slopes]{R package "interactions"},
and \link[lavaan:lavaan-class]{R package "lavaan"}.
Some other R packages or scripts/modules have been further developed to improve the convenience, including
\href{https://jamovi-amm.github.io/}{jamovi module "jAMM"} (by \emph{Marcello Gallucci}, based on the \code{lavaan} package),
\href{https://CRAN.R-project.org/package=processR}{R package "processR"} (by \emph{Keon-Woong Moon}, not official, also based on the \code{lavaan} package),
and \href{https://www.processmacro.org/download.html}{R script file "process.R"}
(the official PROCESS R code by \emph{Andrew F. Hayes}, but it is not yet an R package and has some bugs and limitations).

Here, the \strong{\code{\link[bruceR:PROCESS]{bruceR::PROCESS()}}} function provides
an alternative to performing mediation/moderation analyses in R.
This function supports a total of \strong{24} kinds of SPSS PROCESS models (Hayes, 2018)
and also supports multilevel mediation/moderation analyses.
Overall, it supports the most frequently used types of mediation, moderation,
moderated moderation (3-way interaction), and moderated mediation (conditional indirect effect) analyses
for \strong{(generalized) linear or linear mixed models}.

Specifically, the \strong{\code{\link[bruceR:PROCESS]{bruceR::PROCESS()}}} function
first builds regression models according to the data, variable names, and a few other parameters
that users input (with \strong{no need to} specify the PROCESS model number and \strong{no need to} manually mean-center the variables).
The function can automatically judge the model number/type and also automatically conduct mean-centering before model building.

Then, it uses:
\enumerate{
  \item the \code{\link[interactions:sim_slopes]{interactions::sim_slopes()}} function to
  estimate simple slopes (and conditional direct effects) in moderation, moderated moderation, and moderated mediation models
  (PROCESS Models 1, 2, 3, 5, 7, 8, 9, 10, 11, 12, 14, 15, 16, 17, 18, 19, 58, 59, 72, 73, 75, 76).
  \item the \code{\link[mediation:mediate]{mediation::mediate()}} function to
  estimate (conditional) indirect effects in (moderated) mediation models
  (PROCESS Models 4, 5, 7, 8, 9, 10, 11, 12, 14, 15, 16, 17, 18, 19, 58, 59, 72, 73, 75, 76).
  \item the \code{\link[lavaan:sem]{lavaan::sem()}} function to perform serial multiple mediation analysis (PROCESS Model 6).
}
If you use this function in your research and report its results in your paper, please cite not only \code{bruceR} but also
the other R packages it uses internally (\code{mediation}, \code{interactions}, and/or \code{lavaan}).

Two parts of results are printed:
(1) \emph{regression model summary} (using \code{\link[bruceR:model_summary]{bruceR::model_summary()}} to summarize the models)
and (2) \emph{mediation/moderation effect estimates} (using one or a combination of the above packages and functions to estimate the effects).
To organize the Part 2 output, the results of \strong{Simple Slopes} are titled in \strong{green},
whereas the results of \strong{Indirect Path} are titled in \strong{blue}.

\strong{\emph{Disclaimer}:}
Although this function is named after \code{PROCESS}, Andrew F. Hayes has no role in its design, and
its development is independent from the official SPSS PROCESS macro and "process.R" script.
Any error or limitation should be attributed to the three R packages/functions that \code{bruceR::PROCESS()} uses internally.
Moreover, as mediation analyses include \emph{random processes} (i.e., bootstrap resampling or Monte Carlo simulation),
the results of mediation analyses are \emph{unlikely} to be exactly the same across different software
(even if you set the same random seed in different software).
}
\details{
For more details and illustrations, see
\href{https://github.com/psychbruce/bruceR/tree/master/note}{PROCESS-bruceR-SPSS} (PDF and Markdown files).
}
\examples{
\donttest{#### NOTE ####
## In the following examples, I set nsim=100 to save time.
## In formal analyses, nsim=1000 (or larger) is suggested!

#### Demo Data ####
# ?mediation::student
data=mediation::student \%>\%
  dplyr::select(SCH_ID, free, smorale, pared, income,
                gender, work, attachment, fight, late, score)
names(data)[2:3]=c("SCH_free", "SCH_morale")
names(data)[4:7]=c("parent_edu", "family_inc", "gender", "partjob")
data$gender01=1-data$gender  # 0 = female, 1 = male
# dichotomous X: as.factor()
data$gender=factor(data$gender01, levels=0:1, labels=c("Female", "Male"))
# dichotomous Y: as.factor()
data$pass=as.factor(ifelse(data$score>=50, 1, 0))

#### Descriptive Statistics and Correlation Analyses ####
Freq(data$gender)
Freq(data$pass)
Describe(data)     # file="xxx.doc"
Corr(data[,4:11])  # file="xxx.doc"

#### PROCESS Analyses ####

## Model 1 ##
PROCESS(data, y="score", x="late", mods="gender")  # continuous Y
PROCESS(data, y="pass", x="late", mods="gender")   # dichotomous Y

# (multilevel moderation)
PROCESS(data, y="score", x="late", mods="gender",  # continuous Y (LMM)
        clusters="SCH_ID")
PROCESS(data, y="pass", x="late", mods="gender",   # dichotomous Y (GLMM)
        clusters="SCH_ID")

# (Johnson-Neyman (J-N) interval and plot)
PROCESS(data, y="score", x="gender", mods="late")->P
P$results[[1]]$jn[[1]]       # Johnson-Neyman interval
P$results[[1]]$jn[[1]]$plot  # Johnson-Neyman plot (ggplot object)
GLM_summary(P$model.y)       # detailed results of regression

# (allows multicategorical moderator)
d=airquality
d$Month=as.factor(d$Month)  # moderator: factor with levels "5"~"9"
PROCESS(d, y="Temp", x="Solar.R", mods="Month")

## Model 2 ##
PROCESS(data, y="score", x="late",
        mods=c("gender", "family_inc"),
        mod.type="2-way")  # or omit "mod.type", default is "2-way"

## Model 3 ##
PROCESS(data, y="score", x="late",
        mods=c("gender", "family_inc"),
        mod.type="3-way")
PROCESS(data, y="pass", x="gender",
        mods=c("late", "family_inc"),
        mod1.val=c(1, 3, 5),     # moderator 1: late
        mod2.val=seq(1, 15, 2),  # moderator 2: family_inc
        mod.type="3-way")

## Model 4 ##
PROCESS(data, y="score", x="parent_edu",
        meds="family_inc", covs="gender",
        ci="boot", nsim=100, seed=1)

# (allows an infinite number of multiple mediators in parallel)
PROCESS(data, y="score", x="parent_edu",
        meds=c("family_inc", "late"),
        covs=c("gender", "partjob"),
        ci="boot", nsim=100, seed=1)

# (multilevel mediation)
PROCESS(data, y="score", x="SCH_free",
        meds="late", clusters="SCH_ID",
        ci="mcmc", nsim=100, seed=1)

## Model 6 ##
PROCESS(data, y="score", x="parent_edu",
        meds=c("family_inc", "late"),
        covs=c("gender", "partjob"),
        med.type="serial",
        ci="boot", nsim=100, seed=1)

## Model 8 ##
PROCESS(data, y="score", x="fight",
        meds="late",
        mods="gender",
        mod.path=c("x-m", "x-y"),
        ci="boot", nsim=100, seed=1)

## For more examples and details, see the "note" subfolder at:
## https://github.com/psychbruce/bruceR
}

}
\references{
Hayes, A. F. (2018). \emph{Introduction to mediation, moderation, and conditional process analysis (second edition): A regression-based approach}. Guilford Press.

Yzerbyt, V., Muller, D., Batailler, C., & Judd, C. M. (2018).
New recommendations for testing indirect effects in mediational models:
The need to report and test component paths.
\emph{Journal of Personality and Social Psychology, 115}(6), 929-943.
\doi{10.1037/pspa0000132}
}
\seealso{
\code{\link{lavaan_summary}}

\code{\link{model_summary}}

\code{\link{med_summary}}
}
