% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR-stats_3_manova.R
\name{MANOVA}
\alias{MANOVA}
\title{Multi-factor ANOVA.}
\usage{
MANOVA(
  data,
  subID = NULL,
  dv = NULL,
  dvs = NULL,
  dvs.pattern = NULL,
  between = NULL,
  within = NULL,
  covariate = NULL,
  ss.type = "III",
  sph.correction = "none",
  aov.include = FALSE,
  digits = 3,
  file = NULL
)
}
\arguments{
\item{data}{Data frame. Both \strong{wide-format} and \strong{long-format} are supported.}

\item{subID}{Subject ID (the column name). Only necessary for \strong{long-format} data.}

\item{dv}{Dependent variable.
\itemize{
  \item For \strong{wide-format} data, \code{dv} only can be used for between-subjects designs.
  For within-subjects and mixed designs, please use \code{dvs} and \code{dvs.pattern}.
  \item For \strong{long-format} data, \code{dv} is the outcome variable.
}}

\item{dvs}{Repeated measures. Only for \strong{wide-format} data (within-subjects or mixed designs).

Can be:
\itemize{
  \item \code{"start:stop"} to specify the range of variables
  (sensitive to the order of variables):

  e.g., \code{"A1B1:A2B3"} is matched to all variables in the data
  between \code{"A1B1"} and \code{"A2B3"}

  \item a character vector to directly specify variables
  (insensitive to the order of variables):

  e.g., \code{c("Cond1", "Cond2", "Cond3")} or \code{cc("Cond1, Cond2, Cond3")}

  See \code{\link{cc}} for its usage.
}}

\item{dvs.pattern}{If you use \code{dvs}, you should also specify the pattern of variable names
using \emph{regular expression}.

Examples:
\itemize{
  \item \code{"Cond(.)"} extracts levels from \code{"Cond1", "Cond2", "Cond3", ...}
  You may rename the factor using the \code{within} argument (e.g., \code{within="Condition"})
  \item \code{"X(..)Y(..)"} extracts levels from \code{"X01Y01", "X02Y02", "XaaYbc", ...}
  \item \code{"X(.+)Y(.+)"} extracts levels from \code{"X1Y1", "XaYb", "XaY002", ...}
}

Tips on regular expression:
\itemize{
  \item \code{"(.)"} extracts any single character (number, letter, and other symbols)
  \item \code{"(.+)"} extracts >= 1 character(s)
  \item \code{"(.*)"} extracts >= 0 character(s)
  \item \code{"([0-9])"} extracts any single number
  \item \code{"([a-z])"} extracts any single letter
  \item More information: \href{https://regexr.com/}{Link 1 (in English)} and
        \href{https://www.jb51.net/shouce/jquery1.82/regexp.html}{Link 2 (in Chinese)}
}}

\item{between}{Between-subjects factor(s). Multiple variables should be included in a character vector \code{c()}.}

\item{within}{Within-subjects factor(s). Multiple variables should be included in a character vector \code{c()}.}

\item{covariate}{Covariates. Multiple variables should be included in a character vector \code{c()}.}

\item{ss.type}{Type of sums of squares (SS) for ANOVA. Defaults to \code{"III"}.
Possible values are \code{"II"}, \code{"III"}, \code{2}, or \code{3}.}

\item{sph.correction}{[Only for repeated measures with >= 3 levels]

Sphericity correction method for adjusting the degrees of freedom (\emph{df}) when the sphericity assumption is violated. Defaults to \code{"none"}.
If Mauchly's test of sphericity is significant, you may set it to \code{"GG"} (Greenhouse-Geisser) or \code{"HF"} (Huynh-Feldt).}

\item{aov.include}{Include the \code{aov} object in the returned object?
Defaults to \code{FALSE}, as suggested by \code{\link[afex:aov_car]{afex::aov_ez()}}
(please see the \code{include_aov} argument in this help page, which provides a detailed explanation).
If \code{TRUE}, you should also specify \code{model.type="univariate"} in \code{\link{EMMEANS}}.}

\item{digits}{Number of decimal places of output. Defaults to \code{3}.}

\item{file}{File name of MS Word (\code{.doc}).}
}
\value{
A result object (list) returned by
\code{\link[afex:aov_car]{afex::aov_ez()}},
along with several other elements:
\code{between}, \code{within},
\code{data.wide}, \code{data.long}.
}
\description{
Multi-factor ANOVA (between-subjects, within-subjects, and mixed designs),
with and without covariates (ANCOVA).

This function is based on and extends \code{\link[afex:aov_car]{afex::aov_ez()}}.
You only need to specify the data, dependent variable(s), and factors
(between-subjects and/or within-subjects).
Almost all results you need will be displayed together,
including effect sizes (partial \eqn{\eta^2}) and their confidence intervals (CIs).
90\% CIs for partial \eqn{\eta^2} (two-sided) are reported, following Steiger (2004).
In addition to partial \eqn{\eta^2}, it also reports generalized \eqn{\eta^2}, following Olejnik & Algina (2003).

How to prepare your data and specify the arguments of \code{MANOVA}?
\itemize{
  \item \strong{Wide-format data} (one person in one row, and repeated measures in multiple columns):
  \describe{
    \item{Betweem-subjects design}{\code{MANOVA(data=, dv=, between=, ...)}}
    \item{Within-subjects design}{\code{MANOVA(data=, dvs=, dvs.pattern=, within=, ...)}}
    \item{Mixed design}{\code{MANOVA(data=, dvs=, dvs.pattern=, between=, within=, ...)}}
  }
  \item \strong{Long-format data} (one person in multiple rows, and repeated measures in one column):
  \describe{
    \item{Betweem-subjects design}{(not applicable)}
    \item{Within-subjects design}{\code{MANOVA(data=, subID=, dv=, within=, ...)}}
    \item{Mixed design}{\code{MANOVA(data=, subID=, dv=, between=, within=, ...)}}
  }
}
}
\details{
If observations are not uniquely identified in user-defined long-format data,
the function takes averages across those multiple observations for each case.
In technical details, it specifies \code{fun_aggregate=mean} in \code{\link[afex:aov_car]{afex::aov_ez()}}
and \code{values_fn=mean} in \code{\link[tidyr:pivot_wider]{tidyr::pivot_wider()}}.
}
\section{Interaction Plot}{

You can save the returned object and use the \code{\link[emmeans:emmip]{emmeans::emmip()}} function
to create an interaction plot (based on the fitted model and a formula specification).
For usage, please see the help page of \code{\link[emmeans:emmip]{emmeans::emmip()}}.
It returns an object of class \code{ggplot}, which can be easily modified and saved using \code{ggplot2} syntax.
}

\examples{
#### Between-Subjects Design ####

between.1
MANOVA(between.1, dv="SCORE", between="A")

between.2
MANOVA(between.2, dv="SCORE", between=c("A", "B"))

between.3
MANOVA(between.3, dv="SCORE", between=c("A", "B", "C"))

## How to create an interaction plot using `emmeans::emmip()`?
## See help page for its usage: ?emmeans::emmip()
m = MANOVA(between.2, dv="SCORE", between=c("A", "B"))
emmip(m, ~ A | B, CIs=TRUE)
emmip(m, ~ B | A, CIs=TRUE)
emmip(m, B ~ A, CIs=TRUE)
emmip(m, A ~ B, CIs=TRUE)


#### Within-Subjects Design ####

within.1
MANOVA(within.1, dvs="A1:A4", dvs.pattern="A(.)",
       within="A")
## the same:
MANOVA(within.1, dvs=c("A1", "A2", "A3", "A4"), dvs.pattern="A(.)",
       within="MyFactor")  # renamed the within-subjects factor

within.2
MANOVA(within.2, dvs="A1B1:A2B3", dvs.pattern="A(.)B(.)",
       within=c("A", "B"))

within.3
MANOVA(within.3, dvs="A1B1C1:A2B2C2", dvs.pattern="A(.)B(.)C(.)",
       within=c("A", "B", "C"))


#### Mixed Design ####

mixed.2_1b1w
MANOVA(mixed.2_1b1w, dvs="B1:B3", dvs.pattern="B(.)",
       between="A", within="B")
MANOVA(mixed.2_1b1w, dvs="B1:B3", dvs.pattern="B(.)",
       between="A", within="B", sph.correction="GG")

\donttest{mixed.3_1b2w
MANOVA(mixed.3_1b2w, dvs="B1C1:B2C2", dvs.pattern="B(.)C(.)",
       between="A", within=c("B", "C"))

mixed.3_2b1w
MANOVA(mixed.3_2b1w, dvs="B1:B2", dvs.pattern="B(.)",
       between=c("A", "C"), within="B")


#### Other Examples ####

data.new = mixed.3_1b2w
names(data.new) = c("Group", "Cond_01", "Cond_02", "Cond_03", "Cond_04")
MANOVA(data.new,
       dvs="Cond_01:Cond_04",
       dvs.pattern="Cond_(..)",
       between="Group",
       within="Condition")  # rename the factor

# ?afex::obk.long
MANOVA(afex::obk.long,
       subID="id",
       dv="value",
       between=c("treatment", "gender"),
       within=c("phase", "hour"),
       cov="age",
       sph.correction="GG")
}
}
\references{
Olejnik, S., & Algina, J. (2003). Generalized eta and omega squared statistics: Measures of effect size for some common research designs.
\emph{Psychological Methods, 8}(4), 434--447.

Steiger, J. H. (2004). Beyond the F test: Effect size confidence intervals and tests of close fit in the analysis of variance and contrast analysis.
\emph{Psychological Methods, 9}(2), 164--182.
}
\seealso{
\code{\link{TTEST}}, \code{\link{EMMEANS}}, \code{\link{bruceR-demodata}}
}
