% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cards.R
\name{bs4Card}
\alias{bs4Card}
\title{Create a Boostrap 4 card}
\usage{
bs4Card(..., title = NULL, footer = NULL, status = NULL,
  elevation = NULL, solidHeader = FALSE, headerBorder = TRUE,
  gradientColor = NULL, width = 6, height = NULL,
  collapsible = TRUE, collapsed = FALSE, closable = TRUE,
  labelStatus = NULL, labelText = NULL, labelTooltip = NULL,
  dropdownMenu = NULL, dropdownIcon = "wrench")
}
\arguments{
\item{...}{Contents of the box.}

\item{title}{Optional title.}

\item{footer}{Optional footer text.}

\item{status}{The status of the item This determines the item's background
color. "primary", "success", "warning", "danger". NULL by default.}

\item{elevation}{Card elevation.}

\item{solidHeader}{Should the header be shown with a solid color background?}

\item{headerBorder}{Whether to display a border between the header and body.
TRUE by default}

\item{gradientColor}{If NULL (the default), the background of the box will be
white. Otherwise, a color string. "primary", "success", "warning" or "danger".}

\item{width}{The width of the box, using the Bootstrap grid system. This is
used for row-based layouts. The overall width of a region is 12, so the
default valueBox width of 4 occupies 1/3 of that width. For column-based
layouts, use \code{NULL} for the width; the width is set by the column that
contains the box.}

\item{height}{The height of a box, in pixels or other CSS unit. By default
the height scales automatically with the content.}

\item{collapsible}{If TRUE, display a button in the upper right that allows
the user to collapse the box.}

\item{collapsed}{If TRUE, start collapsed. This must be used with
\code{collapsible=TRUE}.}

\item{closable}{If TRUE, display a button in the upper right that allows the user to close the box.}

\item{labelStatus}{status of the box label: "danger", "success", "primary", "warning".}

\item{labelText}{Label text.}

\item{labelTooltip}{Label tooltip displayed on hover.}

\item{dropdownMenu}{List of items in the the boxtool dropdown menu. Use dropdownItemList().}

\item{dropdownIcon}{Dropdown icon. "wrench" by default.}
}
\description{
Build an adminLTE3 card
}
\examples{
if(interactive()){
 library(shiny)
 library(bs4Dash)

 shiny::shinyApp(
   ui = bs4DashPage(
    navbar = bs4DashNavbar(),
    sidebar = bs4DashSidebar(),
    controlbar = bs4DashControlbar(),
    footer = bs4DashFooter(),
    title = "test",
    body = bs4DashBody(
    fluidRow(
     column(
      width = 6,
      bs4Card(
       title = "Closable Box with dropdown", 
       closable = TRUE, 
       width = 12,
       status = "warning", 
       solidHeader = FALSE, 
       collapsible = TRUE,
       labelText = 1,
       labelStatus = "danger",
       labelTooltip = "Hi Bro!",
       dropdownIcon = "wrench",
       dropdownMenu = dropdownItemList(
         dropdownItem(url = "http://www.google.com", name = "Link to google"),
         dropdownItem(url = "#", name = "item 2"),
         dropdownDivider(),
         dropdownItem(url = "#", name = "item 3")
       ),
       p("Box Content")
      )
     ),
     column(
      width = 6, 
      bs4Card(
       title = "Closable Box with gradient", 
       closable = TRUE, 
       width = 12,
       status = "warning", 
       solidHeader = FALSE, 
       gradientColor = "success",
       collapsible = TRUE,
       p("Box Content")
      )
     )
     ),
     bs4Card(
       title = "Closable Box with solidHeader", 
       closable = TRUE, 
       width = 6,
       solidHeader = TRUE, 
       status = "primary",
       collapsible = TRUE,
       p("Box Content")
      )
    )
   ),
   server = function(input, output) {}
 )
}

}
\seealso{
Other cards: \code{\link{bs4InfoBox}},
  \code{\link{bs4TabCard}}, \code{\link{bs4ValueBox}}
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
\concept{cards}
