% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dashboardSidebar.R, R/aliases.R
\name{bs4DashSidebar}
\alias{bs4DashSidebar}
\alias{updatebs4Sidebar}
\alias{bs4SidebarMenu}
\alias{bs4SidebarMenuItem}
\alias{bs4SidebarMenuSubItem}
\alias{bs4SidebarHeader}
\alias{bs4SidebarUserPanel}
\alias{updatebs4TabItems}
\alias{dashboardSidebar}
\alias{updateSidebar}
\alias{sidebarHeader}
\alias{sidebarMenu}
\alias{sidebarUserPanel}
\alias{menuItem}
\alias{menuSubItem}
\alias{updateTabItems}
\title{Create a Boostrap 4 dashboard main sidebar}
\usage{
bs4DashSidebar(
  ...,
  disable = FALSE,
  width = NULL,
  skin = "dark",
  status = "primary",
  elevation = 4,
  collapsed = FALSE,
  minified = TRUE,
  expandOnHover = TRUE,
  fixed = TRUE,
  id = NULL,
  customArea = NULL
)

updatebs4Sidebar(id, session = shiny::getDefaultReactiveDomain())

bs4SidebarMenu(
  ...,
  id = NULL,
  .list = NULL,
  flat = FALSE,
  compact = FALSE,
  childIndent = TRUE,
  legacy = FALSE
)

bs4SidebarMenuItem(
  text,
  ...,
  icon = NULL,
  badgeLabel = NULL,
  badgeColor = "success",
  tabName = NULL,
  href = NULL,
  newTab = TRUE,
  selected = NULL,
  expandedName = as.character(gsub("[[:space:]]", "", text)),
  startExpanded = FALSE,
  condition = NULL,
  .list = NULL
)

bs4SidebarMenuSubItem(
  text,
  tabName = NULL,
  href = NULL,
  newTab = NULL,
  icon = shiny::icon("angle-double-right"),
  selected = NULL
)

bs4SidebarHeader(title)

bs4SidebarUserPanel(name, image = NULL)

updatebs4TabItems(
  session = shiny::getDefaultReactiveDomain(),
  inputId,
  selected = NULL
)

dashboardSidebar(
  ...,
  disable = FALSE,
  width = NULL,
  skin = "dark",
  status = "primary",
  elevation = 4,
  collapsed = FALSE,
  minified = TRUE,
  expandOnHover = TRUE,
  fixed = TRUE,
  id = NULL,
  customArea = NULL
)

updateSidebar(id, session = shiny::getDefaultReactiveDomain())

sidebarHeader(title)

sidebarMenu(
  ...,
  id = NULL,
  .list = NULL,
  flat = FALSE,
  compact = FALSE,
  childIndent = TRUE,
  legacy = FALSE
)

sidebarUserPanel(name, image = NULL)

menuItem(
  text,
  ...,
  icon = NULL,
  badgeLabel = NULL,
  badgeColor = "success",
  tabName = NULL,
  href = NULL,
  newTab = TRUE,
  selected = NULL,
  expandedName = as.character(gsub("[[:space:]]", "", text)),
  startExpanded = FALSE,
  condition = NULL,
  .list = NULL
)

menuSubItem(
  text,
  tabName = NULL,
  href = NULL,
  newTab = NULL,
  icon = shiny::icon("angle-double-right"),
  selected = NULL
)

updateTabItems(
  session = shiny::getDefaultReactiveDomain(),
  inputId,
  selected = NULL
)
}
\arguments{
\item{...}{\link{menuSubItem}.}

\item{disable}{If \code{TRUE}, the sidebar will be disabled.}

\item{width}{The width of the sidebar. This must either be a number which
specifies the width in pixels, or a string that specifies the width in CSS
units.}

\item{skin}{Sidebar skin. "dark" or "light".}

\item{status}{Sidebar status. Valid statuses are defined as follows:
\itemize{
  \item \code{primary}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#007bff")}.
  \item \code{secondary}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#6c757d")}.
  \item \code{info}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#17a2b8")}.
  \item \code{success}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#28a745")}.
  \item \code{warning}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#ffc107")}.
  \item \code{danger}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#dc3545")}.
  \item \code{gray-dark}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#343a40")}.
  \item \code{gray}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#adb5bd")}.
  \item \code{white}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#fff")}.
  \item \code{indigo}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#6610f2")}.
  \item \code{lightblue}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#3c8dbc")}.
  \item \code{navy}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#001f3f")}.
  \item \code{purple}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#605ca8")}.
  \item \code{fuchsia}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#f012be")}.
  \item \code{pink}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#e83e8c")}.
  \item \code{maroon}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#d81b60")}.
  \item \code{orange}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#ff851b")}.
  \item \code{lime}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#01ff70")}.
  \item \code{teal}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#39cccc")}.
  \item \code{olive}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#3d9970")}.
}}

\item{elevation}{Sidebar elevation. 4 by default (until 5).}

\item{collapsed}{If \code{TRUE}, the sidebar will be collapsed on app startup.}

\item{minified}{Whether to slightly close the sidebar but still show item icons. Default
to TRUE.}

\item{expandOnHover}{Whether to expand the sidebar om hover. TRUE by default.}

\item{fixed}{Whether to fix the sidebar. Default to TRUE.}

\item{id}{For \link{sidebarMenu}, if \code{id} is present, this id will be
used for a Shiny input value, and it will report which tab is selected. For
example, if \code{id="tabs"}, then \code{input$tabs} will be the
\code{tabName} of the currently-selected \link{menuItem}.}

\item{customArea}{Sidebar bottom space area. Only works if sidebar is fixed.}

\item{session}{Shiny session object.}

\item{.list}{An optional list containing items to put in the menu Same as the
\code{...} arguments, but in list format. This can be useful when working
with programmatically generated items.}

\item{flat}{Whether sidebar items should have a flat design. FALSE by default.}

\item{compact}{Whether items should be compacted. FALSE by default.}

\item{childIndent}{Whether to indent children. TRUE by default.}

\item{legacy}{Whether to use the old adminLTE2 item selection display. Default
to FALSE.}

\item{text}{Item name.}

\item{icon}{An icon tag, created by \code{\link[shiny]{icon}}. If
\code{NULL}, don't display an icon.}

\item{badgeLabel}{A label for an optional badge. Usually a number or a short
word like "new".}

\item{badgeColor}{A color for the badge. Valid colors:
\itemize{
  \item \code{primary}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#007bff")}.
  \item \code{secondary}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#6c757d")}.
  \item \code{info}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#17a2b8")}.
  \item \code{success}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#28a745")}.
  \item \code{warning}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#ffc107")}.
  \item \code{danger}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#dc3545")}.
}}

\item{tabName}{Should correspond exactly to the tabName given in \code{\link{tabItem}}.}

\item{href}{An link address. Not compatible with \code{tabName}.}

\item{newTab}{If \code{href} is supplied, should the link open in a new
browser tab?}

\item{selected}{If \code{TRUE}, this \code{menuSubItem}
will start selected. If no item have \code{selected=TRUE}.}

\item{expandedName}{A unique name given to each \code{menuItem} that serves
to indicate which one (if any) is currently expanded. (This is only applicable
to \code{menuItem}s that have children and it is mostly only useful for
bookmarking state.)}

\item{startExpanded}{Whether to expand the \link{menuItem} at start.}

\item{condition}{When using \link{menuItem} with \link[shiny]{conditionalPanel},
write the condition here (see \url{https://github.com/RinteRface/bs4Dash/issues/35}).}

\item{title}{title.}

\item{name}{Name of the user.}

\item{image}{A filename or URL to use for an image of the person. If it is a
local file, the image should be contained under the www/ subdirectory of
the application.}

\item{inputId}{The id of the \code{tabsetPanel}, \code{navlistPanel},
or \code{navbarPage} object.}
}
\description{
\link{dashboardSidebar} creates an adminLTE3 dashboard main sidebar to
insert in the sidebar slot of \link{dashboardPage}.

\link{updateSidebar} toggles a \link{dashboardSidebar} on the client.

\link{sidebarMenu} creates a menu for \link{dashboardSidebar}.

\link{menuItem} creates an item to put in \link{sidebarMenu}.

\link{menuSubItem} creates an item to put in \link{menuItem}.

\link{sidebarHeader} creates a header to put in \link{dashboardSidebar}.

\link{sidebarUserPanel} creates a user Panel to put in \link{dashboardSidebar}.

\link{updateTabItems} controls the active tab of \code{\link{tabItems}} from the
server. It behaves just like \code{\link[shiny]{updateTabsetPanel}}.
}
\note{
See examples for a use case of the condition parameter.
}
\examples{
if (interactive()) {
  library(shiny)
  library(bs4Dash)

  shinyApp(
    ui = dashboardPage(
      header = dashboardHeader(),
      sidebar = dashboardSidebar(id = "sidebar"),
      body = dashboardBody(
        actionButton(inputId = "sidebarToggle", label = "Toggle Sidebar")
      )
    ),
    server = function(input, output, session) {
      observeEvent(input$sidebar, {
        if (input$sidebar) {
          showModal(modalDialog(
            title = "Alert",
            "The sidebar is opened.",
            easyClose = TRUE,
            footer = NULL
          ))
        }
      })

      observeEvent(input$sidebarToggle, {
        updateSidebar(id = "sidebar", session = session)
      })

      observe({
        print(input$sidebar)
      })
    }
  )
}
if (interactive()) {
  # sidebarItem with conditional value
  library(shiny)
  library(bs4Dash)

  ui <- dashboardPage(
    dashboardHeader(),
    dashboardSidebar(
      sidebarMenu(
        id = "sidebarMenu",
        menuItem(
          text = "Tab 1",
          tabName = "tab1"
        ),
        menuItem(
          condition = "input.show == true",
          text = "Tab 2",
          tabName = "tab2"
        )
      )
    ),
    dashboardBody(
      tabItems(
        tabItem(
          tabName = "tab1",
          h1("Welcome!"),
          checkboxInput("show", "Show Tab 2", FALSE)
        ),
        tabItem(
          tabName = "tab2",
          h1("Hey! You found me!")
        )
      )
    )
  )
  server <- function(input, output) {}
  shinyApp(ui = ui, server = server)
}
## Only run this example in interactive R sessions
if (interactive()) {
  library(shiny)
  library(bs4Dash)

  shinyApp(
    ui = dashboardPage(
      header = dashboardHeader(skin = "dark"),
      body = dashboardBody(
        tabItems(
          tabItem(
            tabName = "tab1",
            sliderInput("obs", "Number of observations:",
              min = 0, max = 1000, value = 500
            ),
            plotOutput("distPlot")
          ),
          tabItem(
            tabName = "tab2",
            checkboxGroupInput(
              "variable", "Variables to show:",
              c(
                "Cylinders" = "cyl",
                "Transmission" = "am",
                "Gears" = "gear"
              )
            ),
            tableOutput("data")
          ),
          tabItem(
            tabName = "tab3",
            checkboxInput("val", "Some value", FALSE),
            textOutput("value")
          ),
          tabItem(
            tabName = "tab4",
            "Nothing special here!"
          ),
          tabItem(
            tabName = "tab5",
            "Tab 5"
          ),
          tabItem(
            tabName = "tab6",
            "Tab 6"
          ),
          tabItem(
            tabName = "tab7",
            "Tab 7"
          )
        )
      ),
      sidebar = dashboardSidebar(
        skin = "light",
        inputId = "sidebarState",
        sidebarMenu(
          id = "sidebar",
          menuItem(
            text = "Tab 1",
            tabName = "tab1",
            icon = icon("shuttle-van")
          ),
          menuItem(
            text = "Tab 2",
            tabName = "tab2",
            icon = icon("space-shuttle"),
            selected = TRUE
          ),
          menuItem(
            text = "Item List 1",
            icon = icon("bars"),
            startExpanded = TRUE,
            menuSubItem(
              text = "Item 3",
              tabName = "tab3",
              icon = icon("circle-thin")
            ),
            menuSubItem(
              text = "Item 4",
              tabName = "tab4",
              icon = icon("circle-thin")
            )
          ),
          menuItem(
            text = "Item List 2",
            icon = icon("bars"),
            startExpanded = FALSE,
            menuSubItem(
              text = "Item 5",
              tabName = "tab5",
              icon = icon("circle-thin")
            ),
            menuSubItem(
              text = "Item 6",
              tabName = "tab6",
              icon = icon("circle-thin")
            )
          ),
          menuItem(
            text = "Tab 7",
            tabName = "tab7",
            icon = icon("home")
          )
        )
      ),
      controlbar = dashboardControlbar(
        skin = "light",
        sliderInput(
          inputId = "controller",
          label = "Update the first tabset",
          min = 1,
          max = 6,
          value = 2
        )
      ),
      footer = bs4DashFooter()
    ),
    server = function(input, output, session) {
      observe(print(input$sidebarItemExpanded))
      observe(print(input$sidebar))

      # update tabset1
      observeEvent(input$controller,
        {
          updateTabItems(
            session,
            inputId = "sidebar",
            selected = paste0("tab", input$controller)
          )
        },
        ignoreInit = TRUE
      )

      output$distPlot <- renderPlot({
        hist(rnorm(input$obs))
      })

      output$data <- renderTable(
        {
          mtcars[, c("mpg", input$variable), drop = FALSE]
        },
        rownames = TRUE
      )

      output$value <- renderText({
        input$val
      })
    }
  )
}
}
\seealso{
\link{dashboardBody}
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
