% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{bs_modal}
\alias{bs_modal}
\title{Create a Bootstrap modal}
\usage{
bs_modal(
  id,
  title = h5("Note"),
  body,
  footer = button(type = "button", class = "btn btn-secondary", custom_attr =
    list(`data-bs-dismiss` = "modal"), "Close"),
  modal_class = "modal",
  dialog_class = "modal-dialog",
  content_class = "modal-content",
  header_class = "modal-header",
  title_class = "modal-title",
  body_class = "modal-body",
  footer_class = "modal-footer"
)
}
\arguments{
\item{id}{A string, an id for the modal (to launch the modal, reference this id in the HTML element
that will launch the modal. See example below).}

\item{title}{A string, likely HTML, displayed as the title of the modal.}

\item{body}{A string, likely HTML, displayed as the body of the modal.}

\item{footer}{A string, likely HTML, displayed at the bottom of the modal.}

\item{modal_class}{A string, the class added to the the div wrapping the dialog.}

\item{dialog_class}{A string, the class added to the the div wrapping the content wrapper.}

\item{content_class}{A string, the class added to the the div wrapping the content (header, body, footer).}

\item{header_class}{A string, the class added to the the div wrapping the header.}

\item{title_class}{A string, the class added to the the div wrapping the title.}

\item{body_class}{A string, the class added to the div wrapping the body.}

\item{footer_class}{A string, the class added to the div wrapping the footer.}
}
\value{
A string of HTML.
}
\description{
Create a Bootstrap modal
}
\examples{
div(
button(
type = "button",
class = "btn btn-primary",
custom_attr = list(
  "data-bs-toggle" = "modal",
  "data-bs-target" = "#modal1"
),
"Launch Modal"
),
bs_modal(
  id = "modal1",
  body = p("Here is the modal.")
)
)
}
