% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimize_model.R
\name{optimize_model.bgmfit}
\alias{optimize_model.bgmfit}
\alias{optimize_model}
\title{Optimize SITAR model}
\usage{
\method{optimize_model}{bgmfit}(
  model,
  newdata = NULL,
  optimize_df = NULL,
  optimize_x = list(NULL, log, sqrt),
  optimize_y = list(NULL, log, sqrt),
  exclude_default_funs = TRUE,
  add_fit_criteria = NULL,
  add_bayes_R = NULL,
  byresp = FALSE,
  digits = 2,
  cores = 1,
  expose_function = NULL,
  verbose = FALSE,
  envir = NULL,
  ...
)

optimize_model(model, ...)
}
\arguments{
\item{model}{An object of class \code{bgmfit}.}

\item{newdata}{An optional data frame to be used in estimation. If
\code{NULL} (default), the \code{newdata} is retrieved from the
\code{model}.}

\item{optimize_df}{A list of integers specifying the degree of freedom
(\code{df}) values to be optimized. If \code{NULL} (default), the \code{df}
is taken from the original model. For optimization over different
\code{df}, say for example \code{df} 4 and \code{df} 5, the corresponding
code is \code{optimize_df = list(4,5)}. For \code{univariate_by} and
\code{multivariate} models, \code{optimize_df} can be a single integer
(e.g., \code{optimize_df = 4}) or a list (e.g., \code{optimize_df =
  list(4,5)}), or a a list of lists. As an example, consider optimization
over \code{df} 4 and \code{df} 5 for the first sub model, and \code{df} 5
and \code{df} 6 for the second sub model, the corresponding code is
\code{optimize_df = list(list(4,5), list(5,6))}.}

\item{optimize_x}{A vector specifying the transformations for the predictor
variable (i.e., \code{x}). The options available are \code{NULL},
\code{'log'}, \code{'sqrt'}, or their combinations. Note that user need not
to enclose these options in a single or double quotes as they are take care
of internally. The default setting is to explore all possible combination
i.e., \code{optimize_x = list(NULL, log,  sqrt)}. Similar to the
\code{optimize_df}, user can specify different \code{optimize_x} for
\code{univariate_by} and \code{multivariate} sub models.}

\item{optimize_y}{A vector specifying the transformations of the the response
variable (i.e., \code{y}). The approach and options available for
\code{optimize_y} are same as described above for the \code{optimize_x}.}

\item{exclude_default_funs}{A logical to indicate whether transformations for
(\code{x} and \code{y}) variables used in the original model fit should be
excluded. If \code{TRUE} (default), the transformations specified for the
\code{x} and \code{y} variables in the original model fit are excluded from
the \code{optimize_x} and \code{optimize_y}. From example, if original
model is fit with \code{xvar = log} and \code{yvar = NULL}, then
\code{optimize_x} is translated into \code{optimize_x = list(NULL, sqrt)},
and similarly \code{optimize_y} is reset as \code{optimize_y = list(log,
  sqrt)}.}

\item{add_fit_criteria}{An optional argument (default \code{NULL}) to
indicate whether to add fit criteria to the returned model fit. Options
available are \code{'loo'} and \code{'waic'}. Please see
\code{\link[brms:add_criterion]{brms::add_criterion()}} for details.}

\item{add_bayes_R}{An optional argument (default \code{NULL}) to indicate
whether to add Bayesian R square to the returned model fit. To estimate and
add \code{bayes_R2} to the model fit, the argument \code{add_bayes_R} is
set as \code{add_bayes_R = 'bayes_R2'}.}

\item{byresp}{A logical (default \code{FALSE}) to indicate if response wise
fit criteria to be calculated. This argument is evaluated only for the
\code{multivariate} model in which user can select whether to get joint
calculation of point wise log likelihood (\code{byresp = FALSE}) or
response specific (\code{byresp = TRUE}). For, \code{univariate_by} model,
the only option available is to calculate separate point wise log
likelihood for each sub-model, i.e., \code{byresp = TRUE}.}

\item{digits}{An integer (default \code{2}) to set the decimal argument for
the \code{\link[base:Round]{base::round()}} function.}

\item{cores}{The number of cores to used in parallel processing (default
\code{1}). The argument \code{cores} is passed to the
\code{\link[brms:add_criterion]{brms::add_criterion()}}.}

\item{expose_function}{An optional argument logical argument to indicate
whether to expose Stan function used in model fitting (\code{TRUE}) or not
(\code{FALSE}). Default \code{NULL} takes \code{expose_function} from the
\code{model} being optimized. Note that \code{expose_function} must be set
as \code{TRUE} when adding \code{fit criteria} and/or \code{bayes_R2}.}

\item{verbose}{An optional argument (logical, default \code{FALSE}) to
indicate whether to print information collected during setting up the
object(s).}

\item{envir}{Environment used for function evaluation. The default is
\code{NULL} which will set \code{parent.frame()} as default environment.
Note that since most of post processing functions are based on \pkg{brms},
the functions needed for evaluation should be in the \code{.GlobalEnv}.
Therefore, it is strongly recommended to set \code{ envir = globalenv()}
(or \code{envir = .GlobalEnv}). This is particularly true for the
derivatives such as velocity curve.}

\item{...}{Other arguments passed to \code{\link{update_model}}.}
}
\value{
A list containing the optimized models of class \code{bgmfit}, and the
the summary statistics if \code{add_fit_criteria} and/or
\code{add_bayes_R} are specified.
}
\description{
Select the best fitting SITAR model that involves choosing the
optimum degrees of freedom (\code{df}) for the natural cubic-spline curve
and the appropriate transformations of the predictor \code{x} and response
\code{y} variables.
}
\examples{

model <- berkeley_mfit

\donttest{

# Fit Bayesian SITAR model 

# To avoid mode estimation which takes time, a model fitted to the 
# 'berkeley_mdata' has already been saved as 'berkeley_mfit'. 
# Details on 'berkeley_mdata' and 'berkeley_mfit' are provided in the 
# 'bsitar' function.

model <- berkeley_mfit

# Below example shows dummy call to optimization to save time. 
# Note that in case degree of freedom and both  optimize_x and optimize_y are
# NULL (i.e., nothing to optimize), the original model object is returned.   
# To explicitly get this information whether model is being optimized or not, 
# user can set verbose = TRUE. The verbose = TRUE also useful in getting the
# information regarding what all arguments have been changed as compared to
# the original model.

model2 <- optimize_model(model, optimize_df = NULL, 
  optimize_x = NULL, 
  optimize_y = NULL,
  verbose = TRUE)

}

}
\seealso{
\code{\link[brms:add_criterion]{brms::add_criterion()}}
}
\author{
Satpal Sandhu  \email{satpal.sandhu@bristol.ac.uk}
}
