% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_curves.R
\name{plot_curves.bgmfit}
\alias{plot_curves.bgmfit}
\alias{plot_curves}
\title{Plot growth curves}
\usage{
\method{plot_curves}{bgmfit}(
  model,
  opt = "dv",
  apv = FALSE,
  bands = NULL,
  conf = 0.95,
  resp = NULL,
  ndraws = NULL,
  draw_ids = NULL,
  newdata = NULL,
  summary = TRUE,
  digits = 2,
  re_formula = NULL,
  numeric_cov_at = NULL,
  aux_variables = NULL,
  levels_id = NULL,
  avg_reffects = NULL,
  ipts = 10,
  deriv_model = TRUE,
  xrange = NULL,
  xrange_search = NULL,
  takeoff = FALSE,
  trough = FALSE,
  acgv = FALSE,
  acgv_velocity = 0.1,
  seed = 123,
  estimation_method = "fitted",
  allow_new_levels = FALSE,
  sample_new_levels = "uncertainty",
  incl_autocor = TRUE,
  robust = FALSE,
  future = FALSE,
  future_session = "multisession",
  cores = NULL,
  trim = 0,
  layout = "single",
  linecolor = NULL,
  linecolor1 = NULL,
  linecolor2 = NULL,
  label.x = NULL,
  label.y = NULL,
  legendpos = NULL,
  linetype.apv = NULL,
  linewidth.main = NULL,
  linewidth.apv = NULL,
  linetype.groupby = NA,
  color.groupby = NA,
  band.alpha = NULL,
  show_age_takeoff = TRUE,
  show_age_peak = TRUE,
  show_age_cessation = TRUE,
  show_vel_takeoff = FALSE,
  show_vel_peak = FALSE,
  show_vel_cessation = FALSE,
  returndata = FALSE,
  returndata_add_parms = FALSE,
  parms_eval = FALSE,
  idata_method = NULL,
  parms_method = "getPeak",
  verbose = FALSE,
  fullframe = NULL,
  dummy_to_factor = NULL,
  usesavedfuns = FALSE,
  clearenvfuns = NULL,
  envir = NULL,
  ...
)

plot_curves(model, ...)
}
\arguments{
\item{model}{An object of class \code{bgmfit}.}

\item{opt}{A character string containing letter(s) corresponding to the
following plotting options: 'd' for population average distance curve, 'v'
for population average velocity curve, 'D' for individual-specific distance
curves, 'V' for individual-specific velocity curves, 'u' for unadjusted
individual-specific distance curves, and 'a' for adjusted
individual-specific distance curves (adjusted for the random effects).
Options 'd' and 'D' can not be specified simultaneously. Likewise, Options
'v' and 'V' can not be specified simultaneously. All other combinations are
allowed. For example, dvau', Dvau', dVau', DVau', or dvau'.}

\item{apv}{An optional logical (default \code{FALSE}) specifying whether or
not to calculate and plot the age at peak velocity (APGV) when \code{opt})
includes 'v' or 'V'.}

\item{bands}{A character string containing letter(s), or \code{NULL} (default)
to indicate if CI bands to be plotted around the distance and velocity
curves (and also the APGV). If \code{NULL}, no band plotted. Alternatively,
user can specify a string with any one of the following or their
combination(s): \code{'d'} for band around the distance curve, \code{'v} for
band around the velocity curve, and \code{'p} for band around the the
vertical line denoting the APGV parameter. The \code{'dvp'} will include CI
bands for distance and velocity curves, and the APGV.}

\item{conf}{A numeric value (default \code{0.95}) to be used to compute the CI
and hence the width of the \code{bands}. See \code{\link[=growthparameters]{growthparameters()}}
for further details.}

\item{resp}{A character string (default \code{NULL}) to specify response
variable when processing posterior draws for the \code{univariate_by} and
\code{multivariate} models. See \code{\link[=bsitar]{bsitar()}} for details on
\code{univariate_by} and \code{multivariate} models}

\item{ndraws}{A positive integer indicating the number of posterior draws to
be used in estimation. If \code{NULL} (default), all draws are used.}

\item{draw_ids}{An integer indicating the specific posterior draw(s)
to be used in estimation (default \code{NULL}).}

\item{newdata}{An optional data frame to be used in estimation. If
\code{NULL} (default), the \code{newdata} is retrieved from the
\code{model}.}

\item{summary}{A logical indicating whether only the estimate should be
computed (\code{TRUE}, default), or estimate along with SE and CI should be
returned (\code{FALSE}). Setting \code{summary} as \code{FALSE} will
increase the computation time.}

\item{digits}{An integer (default \code{2}) to set the decimal argument for
the \code{\link[base:Round]{base::round()}} function.}

\item{re_formula}{Option to indicate whether or not to include the
individual/group-level effects in the estimation. When \code{NA} (default),
the individual-level effects are excluded and therefore population average
growth parameters are computed. When \code{NULL}, individual-level effects
are included in the computation and hence the growth parameters estimates
returned are individual-specific. In both situations, (i.e,, \code{NA} or
\code{NULL}), continuous and factor covariate(s) are appropriately included
in the estimation. The continuous covariates by default are set to their
means (see \code{numeric_cov_at} for details) whereas factor covariates are
left unaltered thereby allowing estimation of covariate specific population
average and individual-specific growth parameter.}

\item{numeric_cov_at}{An optional (named list) argument to specify the value
of continuous covariate(s). The default \code{NULL} option set the
continuous covariate(s) at their mean. Alternatively, a named list can be
supplied to manually set these values. For example, \code{numeric_cov_at =
  list(xx = 2)} will set the continuous covariate varibale 'xx' at 2. The
argument \code{numeric_cov_at} is ignored when no continuous covariate is
included in the model.}

\item{aux_variables}{An optional argument to specify the variables to be
passed to the \code{ipts} argument. This is useful when fitting location
scale models and the measurement error models.}

\item{levels_id}{An optional argument to specify the \code{ids} for
hierarchical model (default \code{NULL}). It is used only when model is
applied to the data with 3 or more levels of hierarchy. For a two level
model, the \code{levels_id} is automatically inferred from the model fit.
Even for 3 or higher level model, the \code{levels_id} is inferred from the
model fit but under the assumption that hierarchy is specified from lowest
to upper most level i.e, \code{id} followed by \code{study} where \code{id}
is nested within the \code{study} Note that it is not guaranteed that the
\code{levels_id} is sorted correctly, and therefore it is better to set it
manually when fitting a model with three or more levels of hierarchy.}

\item{avg_reffects}{An optional argument (default \code{NULL}) to calculate
(marginal/average) curves and growth parameters (such as APGV and PGV). If
specified, it must be a named list indicating the \code{over} (typically
level 1 predictor, such as age), \code{feby} (fixed effects, typically a
factor variable), and  \code{reby} (typically \code{NULL} indicating that
parameters are integrated over the random effects) such as
\code{avg_reffects = list(feby = 'study', reby = NULL, over = 'age'}.}

\item{ipts}{An integer to set the length of the predictor variable to get a
smooth velocity curve. The \code{NULL} will return original values whereas
an integer such as \code{ipts = 10} (default) will interpolate the
predictor. It is important to note that these interpolations do not alter
the range of predictor when calculating population average and/or the
individual specific growth curves.}

\item{deriv_model}{A logical to specify whether to estimate velocity curve
from the derivative function, or the differentiation of the distance curve.
The argument \code{deriv_model} is set to \code{TRUE} for those functions
which need velocity curve such as \code{growthparameters()} and
\code{plot_curves()}, and \code{NULL} for functions which explicitly use
the distance curve (i.e., fitted values) such as \code{loo_validation()}
and \code{plot_ppc()}.}

\item{xrange}{An integer to set the predictor range (i.e., age) when
executing the interpolation via \code{ipts}. The default \code{NULL} sets
the individual specific predictor range whereas code \code{xrange = 1} sets
identical range for individuals within the same higher grouping variable
(e.g., study). Code \code{xrange  = 2} sets the identical range across the
entire sample. Lastly, a paired numeric values can be supplied e.g.,
\code{xrange = c(6, 20)} to set the range within those values.}

\item{xrange_search}{A vector of length two, or a character string
\code{'range'} to set the range of predictor variable (\code{x} ) within
which growth parameters are searched. This is useful when there is more
than one peak and user wants to summarize peak within a given range of the
\code{x} variable. Default \code{xrange_search = NULL}.}

\item{takeoff}{A logical (default \code{FALSE}) to indicate whether
or not to calculate the age at takeoff velocity (ATGV) and the takeoff
growth velocity (TGV) parameters.}

\item{trough}{A logical (default \code{FALSE}) to indicate whether or
not to calculate the age at cessation of growth velocity (ACGV) and the
cessation of growth velocity (CGV) parameters.}

\item{acgv}{A logical (default \code{FALSE}) to indicate whether or not to
calculate the age at cessation of growth velocity from the velocity curve.
If \code{TRUE}, age at cessation of growth velocity (ACGV) and the
cessation growth velocity (CGV) are  calculated based on the percentage of
the peak growth velocity as defined by the \code{acgv_velocity} argument
(see below). The \code{acgv_velocity} is typically set at 10 percent of the
peak growth velocity. The ACGV and CGV are calculated along with the the
uncertainty (SE and CI) around the ACGV and CGV parameters.}

\item{acgv_velocity}{Specify the percentage of the peak growth velocity to be
used when estimating \code{acgv}. The default value is \code{0.10} i.e.,
10 percent of the peak growth velocity.}

\item{seed}{An integer (default \code{123}) that is passed to the estimation
method.}

\item{estimation_method}{A character string to specify the estimation method
when calculating the velocity from the posterior draws. The \code{'fitted'}
method internally calls the \code{\link[=fitted_draws]{fitted_draws()}} whereas the option
\code{predict} calls the \code{\link[=predict_draws]{predict_draws()}}. See
\code{\link[brms:fitted.brmsfit]{brms::fitted.brmsfit()}} and \code{\link[brms:predict.brmsfit]{brms::predict.brmsfit()}} for derails.}

\item{allow_new_levels}{A flag indicating if new levels of group-level
effects are allowed (defaults to \code{FALSE}). Only relevant if
\code{newdata} is provided.}

\item{sample_new_levels}{Indicates how to sample new levels for grouping
factors specified in \code{re_formula}. This argument is only relevant if
\code{newdata} is provided and \code{allow_new_levels} is set to
\code{TRUE}. If \code{"uncertainty"} (default), each posterior sample for a
new level is drawn from the posterior draws of a randomly chosen existing
level. Each posterior sample for a new level may be drawn from a different
existing level such that the resulting set of new posterior draws
represents the variation across existing levels. If \code{"gaussian"},
sample new levels from the (multivariate) normal distribution implied by the
group-level standard deviations and correlations. This options may be useful
for conducting Bayesian power analysis or predicting new levels in
situations where relatively few levels where observed in the old_data. If
\code{"old_levels"}, directly sample new levels from the existing levels,
where a new level is assigned all of the posterior draws of the same
(randomly chosen) existing level.}

\item{incl_autocor}{A flag indicating if correlation structures originally
specified via \code{autocor} should be included in the predictions.
Defaults to \code{TRUE}.}

\item{robust}{A logical to specify the summarize options. If \code{FALSE}
(the default) the mean is used as the measure of central tendency and the
standard deviation as the measure of variability. If \code{TRUE}, the
median and the median absolute deviation (MAD) are applied instead. Ignored
if \code{summary} is \code{FALSE}.}

\item{future}{A logical (default \code{FALSE}) to specify whether or not to
perform parallel computations. If set to \code{TRUE}, the
\code{\link[future.apply:future_lapply]{future.apply::future_sapply()}} function is used to summarize draws.}

\item{future_session}{A character string to set the session type when
\code{future = TRUE}. The \code{'multisession'} (default) options sets the
multisession whereas the \code{'multicore'} sets the multicore session.
Note that option \code{'multicore'} is not supported on Windows systems.
For more details, see \code{\link[future.apply:future_lapply]{future.apply::future_sapply()}}.}

\item{cores}{Number of cores to be used when running the parallel
computations (if \code{future = TRUE}). On non-Windows systems this
argument can be set globally via the mc.cores option. For the default
\code{NULL} option, the number of cores are set automatically by calling
the \code{\link[future:re-exports]{future::availableCores()}}. The number of cores used are the maximum
number of cores avaialble minus one, i.e., \code{future::availableCores() -
  1}.}

\item{trim}{A number (default 0) of long line segments to be excluded from
plot with option 'u' or 'a'. See \link[sitar:plot.sitar]{sitar::plot.sitar} for details.}

\item{layout}{A character string defining the layout structure of the plot. A
\code{'single'} (default) layout provides overlaid distance and velocity
curves on a single plot when opt includes \code{'dv'}, \code{'Dv'},
\code{'dV'} or \code{'DV'} options.  Similarly, when opt includes
\code{'au'}, the adjusted and unadjusted curves are plotted as a single
plot. When opt is a single letter (e.g., \code{'d'}. \code{'v'} \code{'D'},
\code{'V'}, \code{'a'}, \code{'u'}), the \code{'single'} optiion is ignored.
The alternative layout option, the \code{'facet'} uses the \code{facet_wrap}
from the \code{ggplot2}. to map and draw plot when \code{opt} include two or
more letters.}

\item{linecolor}{The color of line used when layout is \code{'facet'}. The
default is \code{NULL} which internally set the \code{linecolor} as
\code{'grey50'}.}

\item{linecolor1}{The color of first line when layout is \code{'single'}. For
example, for \code{opt = 'dv'}, the color of distance line is controlled by
the \code{linecolor1}. Default \code{NULL} will internally set
\code{linecolor1} as \code{'orange2'}.}

\item{linecolor2}{The color of second line when layout is \code{'single'}. For
example, for \code{opt = 'dv'}, the color of velocity line is controlled by
the \code{linecolor2}. Default \code{NULL} sets the color \code{'green4'}
for \code{linecolor2}.}

\item{label.x}{An optional character string to label the x axis. When
\code{NULL} (default), the x axis label is taken from the predictor (e.g.,
age).}

\item{label.y}{An optional character string to label the y axis. When
\code{NULL} (default), the y axis label is taken from the type of plot
(e.g., distance, velocity etc.). Note that when layout option is
\code{'facet'}, then y axis label is removed and instead the same label is
used as a title.}

\item{legendpos}{An optional character string to specify the position of
legends. When \code{NULL} (default), the legend position is set as 'bottom'
for distance and velocity curves with \code{'single'} layout option for the
population average curves, and \code{'none'} for the individual specific
curves. The \code{'none'} suppress all legends that helps in avoiding
printing legends for each individual.}

\item{linetype.apv}{An optional character string to specify the type of the
vertical line drawn to mark the APGV. Default \code{NULL} sets the linetype
as \code{dotted}.}

\item{linewidth.main}{An optional character string to specify the width of the
the line for the distance and velocity curves. The default \code{NULL} will
set it as 0.35.}

\item{linewidth.apv}{An optional character string to specify the width of the
the vertical line drawn to mark the APGV. The default \code{NULL} will set
it as 0.25.}

\item{linetype.groupby}{An optional argument to specify the line type for the
distance and velocity curves when drawing plots for a model that includes
factor covariate(s) or when visualising individual specific
distance/velocity curves (default \code{NA}). Setting it to \code{NULL} will
automatically sets the linetype for each factor level or individual This
will also add legends for the factor level covariate or individuals whereas
\code{NA} will set a 'solid' line type and suppress legends. It is
recommended to keep the default \code{NULL} option when plotting population
average curves for when model included factor covariates because this would
appropriately set the legends otherwise it is difficult to differentiate
which curve belongs to which level of factor. For individual specific
curves, the line type can be set to \code{NULL} when the number of
individuals is small. However, when the number of individuals is large,
\code{NA} is a better choice which prevents printing a large number of
legends for each individual.}

\item{color.groupby}{An optional argument to specify the line color for
distance and velocity curves when drawing plots for a model that includes
factor covariate(s), or when visualising individual specific
distance/velocity curves (default \code{NA}). Setting it to \code{NULL} will
automatically sets the line color for each factor level or individual. This
will also add legends for the factor level covariate or individuals.
However, setting it as \code{NA} will set a 'solid' line type and suppress
legends. It is recommended to keep the default \code{NULL} option when
plotting population average curves for factor covariates because this would
appropriately set the legends otherwise it is difficult to differentiate
which curve belongs to which level of the factor. For individual specific
curves, the line color can be set to \code{NULL} when the number of
individuals is small. However, when the number of individuals is large,
\code{NA} is a better choice which prevents printing a large number of
legends for each individual.}

\item{band.alpha}{An optional numeric value to specify the transparency of the
CI band(s) around the distance curve, velocity curve and the line indicating
the APGV. The default \code{NULL} will set this value to 0.4.}

\item{show_age_takeoff}{A logical (default \code{TRUE}) to indicate whether to
display the ATGV line(s) on the plot.}

\item{show_age_peak}{A logical (default \code{TRUE}) to indicate whether to
display the APGV line(s) on the plot.}

\item{show_age_cessation}{A logical (default \code{TRUE}) to indicate whether
to display the ACGV line(s) on the plot.}

\item{show_vel_takeoff}{A logical (default \code{FALSE}) to indicate whether
to display the TGV line(s) on the plot.}

\item{show_vel_peak}{A logical (default \code{FALSE}) to indicate whether to
display the PGV line(s) on the plot.}

\item{show_vel_cessation}{A logical (default \code{FALSE}) to indicate whether
to display the CGV line(s) on the plot.}

\item{returndata}{A logical (default \code{FALSE}) indicating whether to plot
the data or return the data. If \code{TRUE}, the data is returned as a
\code{data.frame}.}

\item{returndata_add_parms}{A logical (default \code{FALSE}) indicating
whether add growth parameters to the \code{returndata}. The
\code{returndata_add_parms} is ignored when \code{returndata = FALSE}. If
\code{TRUE}, the growth parameters such as \code{APGV} and \code{PGV} are
added to the returned \code{data.frame}. Note that growth parameters are
estimated only when \code{'opt'} argument include either \code{'v'} or
\code{'V'} option and the argument \code{'apv'} is set to \code{TRUE}. If
any of these conditions are missing, then \code{returndata_add_parms} will
ignored ignored.}

\item{parms_eval}{A logical to specify whether or not to get growth
parameters on the fly. This is for internal use only and mainly needed for
compatibility across internal functions.}

\item{idata_method}{A character string to indicate the interpolation method.
The number of of interpolation points is set up the \code{ipts} argument.
Options available for \code{idata_method} are \emph{method 1} (specified as
\code{'m1'}) and \emph{method 2} (specified as \code{'m2'}). The
\emph{method 1} (\code{'m1'}) is adapted from the the \pkg{iapvbs} package
and is documented here
\url{https://rdrr.io/github/Zhiqiangcao/iapvbs/src/R/exdata.R}
whereas \emph{method 2} (\code{'m2'}) is based on the \pkg{JMbayes}
package as documented here
\url{https://github.com/drizopoulos/JMbayes/blob/master/R/dynPred_lme.R}.
The \code{'m1'} method works by internally constructing the data frame based
on the model configuration whereas the method \code{'m2'} uses the exact
data frame used in model fit and can be accessed via \code{fit$data}. If
\code{idata_method = NULL, default}, then method \code{'m2'} is
automatically set. Note that method \code{'m1'} might fail in some cases
when model involves covariates particularly when model is fit as
\code{univariate_by}. Therefore, it is advised to switch to method
\code{'m2'} in case \code{'m1'} results in error.}

\item{parms_method}{A character to specify the method used to when evaluating
\code{parms_eval}. The default is \code{getPeak} which uses the
\code{\link[sitar:getPeakTrough]{sitar::getPeak()}} function from the \code{sitar} package. The alternative
option is \code{findpeaks} that uses the \code{\link[pracma:findpeaks]{pracma::findpeaks()}} function
function from the \code{pracma} package. This is for internal use only and
mainly needed for compatibility across internal functions.}

\item{verbose}{An optional argument (logical, default \code{FALSE}) to
indicate whether to print information collected during setting up the
object(s).}

\item{fullframe}{A logical to indicate whether to return \code{fullframe}
object in which \code{newdata} is bind to the summary estimates. Note that
\code{fullframe} can not be combined with \code{summary = FALSE}.
Furthermore, \code{fullframe} can only be used when \code{idata_method =
  'm2'}. A particular use case is when fitting \code{univariate_by} model.
The \code{fullframe} is mainly for internal use only.}

\item{dummy_to_factor}{A named list (default \code{NULL}) that is used to
convert dummy variables into a factor variable. The named elements are
\code{factor.dummy}, \code{factor.name}, and \code{factor.level}. The
\code{factor.dummy} is a vector of character strings that need to be
converted to a factor variable whereas the \code{factor.name} is a single
character string that is used to name the newly created factor variable.
The \code{factor.level} is used to name the levels of newly created factor.
When \code{factor.name} is \code{NULL}, then the factor name is internally
set as \code{'factor.var'}. If \code{factor.level} is \code{NULL}, then
names of factor levels are take from the \code{factor.dummy} i.e., the
factor levels are assigned same name as \code{factor.dummy}. Note that when
\code{factor.level} is not \code{NULL}, its length must be same as the
length of the \code{factor.dummy}.}

\item{usesavedfuns}{A logical (default \code{FALSE}) to indicate whether to
use the already exposed and saved \code{Stan} functions. This is for
internal purposes only and mainly used during the testing of the functions
and therefore should not be used by users as it might lead to unreliable
estimates.}

\item{clearenvfuns}{A logical to indicate whether to clear the exposed
function from the environment (\code{TRUE}) or not (\code{FALSE}). If
\code{NULL} (default), then \code{clearenvfuns} is set as \code{TRUE} when
\code{usesavedfuns} is \code{TRUE}, and \code{FALSE} if \code{usesavedfuns}
is \code{FALSE}.}

\item{envir}{Environment used for function evaluation. The default is
\code{NULL} which will set \code{parent.frame()} as default environment.
Note that since most of post processing functions are based on \pkg{brms},
the functions needed for evaluation should be in the \code{.GlobalEnv}.
Therefore, it is strongly recommended to set \code{ envir = globalenv()}
(or \code{envir = .GlobalEnv}). This is particularly true for the
derivatives such as velocity curve.}

\item{...}{Further arguments passed to \code{brms::fitted.brmsfit()} and
\code{brms::predict()} functions.}
}
\value{
A plot object (default), or a \code{data.frame} when
\code{returndata = TRUE}.
}
\description{
The \strong{plot_curves()} provides visualization of six
different types of growth curves that are plotted by using the \pkg{ggplot2}
package. The \strong{plot_curves()} also allows users to make their own
detailed plots from the data returned as a \code{data.frame}.
}
\details{
The \strong{plot_curves()} is a generic function that allows
visualization of following six curves: population average distance curve,
population average velocity curve, individual-specific distance curves,
individual-specific velocity curves, unadjusted individual growth curves
(i.e, observed growth curves), and the adjusted individual growth curves
(adjusted for the model estimated random effects). The
\strong{plot_curves()} internally calls the \code{\link[=growthparameters]{growthparameters()}} function to
estimate and summaries the distance and velocity curves and to estimate
growth parameters such as the age at peak growth velocity (APGV). The
\strong{plot_curves()} in turn calls the \code{\link[=fitted_draws]{fitted_draws()}} or the
\code{\link[=predict_draws]{predict_draws()}} functions to make inference from the posterior draws.
Thus, \strong{plot_curves()} allows plotting fitted or predicted curves. See
\code{\link[=fitted_draws]{fitted_draws()}} and \code{\link[=predict_draws]{predict_draws()}} for details on these functions and
the difference between fitted and predicted values.
}
\examples{

# Fit Bayesian SITAR model 

# To avoid mode estimation which takes time, a model fitted to the 
# 'berkeley_mdata' has already been saved as 'berkeley_mfit'. 
# Details on 'berkeley_mdata' and 'berkeley_mfit' are provided in the 
# 'bsitar' function.

model <- berkeley_mfit

# Population average distance and velocity curves with default options
plot_curves(model, opt = 'dv')

\donttest{
# Individual-specific distance and velocity curves with default options
# Note that legendpos = 'none' will suppress the legend positions. This   
# suppression is useful when plotting individual-specific curves

plot_curves(model, opt = 'DV')

# Population average distance and velocity curves with APGV

plot_curves(model, opt = 'dv', apv = TRUE)

# Individual-specific distance and velocity curves with APGV

plot_curves(model, opt = 'DV', apv = TRUE)

# Population average distance curve, velocity curve, and APGV with CI bands
# To construct CI bands, growth parameters are first calculated for each  
# posterior draw and then summarized across draws. Therefore,summary 
# option must be set to FALSE

plot_curves(model, opt = 'dv', apv = TRUE, bands = 'dvp', summary = FALSE)

# Adjusted and unadjusted individual curves
# Note ipts = NULL (i.e., no interpolation of predictor (i.e., age) to plot a 
# smooth curve). This is because it does not a make sense to interploate data 
# when estimating adjusted curves. Also, layout = 'facet' (and not default 
# layout = 'single') is used for the ease of visualizing the plotted 
# adjusted and unadjusted individual curves. However, these lines can be 
# superimposed on each other by setting the set layout = 'single'.
# For other plots shown above, layout can be set as 'single' or 'facet'

# Separate plots for adjusted and unadjusted curves (layout = 'facet')
plot_curves(model, opt = 'au', ipts = NULL, layout = 'facet')

# Superimposed adjusted and unadjusted curves (layout = 'single')
plot_curves(model, opt = 'au', ipts = NULL, layout = 'single')

}

}
\seealso{
\code{\link[=growthparameters]{growthparameters()}} \link{fitted_draws} \code{\link[=predict_draws]{predict_draws()}}
}
\author{
Satpal Sandhu  \email{satpal.sandhu@bristol.ac.uk}
}
