% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post.R
\name{bs_post}
\alias{bs_post}
\title{Make a post on Bluesky Social}
\usage{
bs_post(
  text,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass)
)
}
\arguments{
\item{text}{text of post}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}
}
\value{
a tibble of post information
}
\description{
Note: This function currently only supports text posts. Further support
planned for version 0.1.0
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/app/bsky/feed/post.json}{feed/post.json (2023-10-02)}
\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/com/atproto/repo/createRecord.json}{repo/createRecord.json (2023-10-02)}
}

\section{Function introduced}{

\code{v0.0.1} (2023-10-02)
}

\examples{
\dontshow{if (has_bluesky_pass() & has_bluesky_user()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bs_post('Test post from R CMD Check for r package `bskyr`')
\dontshow{\}) # examplesIf}
}
\concept{repo}
