% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/navs-legacy.R, R/navs.R
\name{navs_tab}
\alias{navs_tab}
\alias{navs_pill}
\alias{navs_pill_list}
\alias{navs_hidden}
\alias{navs_bar}
\alias{navs_tab_card}
\alias{navs_pill_card}
\title{Navigation containers}
\usage{
navs_tab(..., id = NULL, selected = NULL, header = NULL, footer = NULL)

navs_pill(..., id = NULL, selected = NULL, header = NULL, footer = NULL)

navs_pill_list(
  ...,
  id = NULL,
  selected = NULL,
  header = NULL,
  footer = NULL,
  well = TRUE,
  fluid = TRUE,
  widths = c(4, 8)
)

navs_hidden(..., id = NULL, selected = NULL, header = NULL, footer = NULL)

navs_bar(
  ...,
  title = NULL,
  id = NULL,
  selected = NULL,
  position = c("static-top", "fixed-top", "fixed-bottom"),
  header = NULL,
  footer = NULL,
  bg = NULL,
  inverse = "auto",
  collapsible = TRUE,
  fluid = TRUE
)

navs_tab_card(..., id = NULL, selected = NULL, header = NULL, footer = NULL)

navs_pill_card(
  ...,
  id = NULL,
  selected = NULL,
  header = NULL,
  footer = NULL,
  placement = c("above", "below")
)
}
\arguments{
\item{...}{a collection of \code{\link[=nav]{nav()}} items.}

\item{id}{a character string used for dynamically updating the container (see \code{\link[=nav_select]{nav_select()}}).}

\item{selected}{a character string matching the \code{value} of a particular \code{\link[=nav]{nav()}} item to selected by default.}

\item{header}{UI element(s) (\link{tags}) to display \emph{above} the nav content.}

\item{footer}{UI element(s) (\link{tags}) to display \emph{below} the nav content.}

\item{well}{\code{TRUE} to place a well (gray rounded rectangle) around the
navigation list.}

\item{fluid}{\code{TRUE} to use fluid layout; \code{FALSE} to use fixed
layout.}

\item{widths}{Column widths of the navigation list and tabset content areas
respectively.}

\item{title}{The title to display in the navbar}

\item{position}{Determines whether the navbar should be displayed at the top
of the page with normal scrolling behavior (\code{"static-top"}), pinned at
the top (\code{"fixed-top"}), or pinned at the bottom
(\code{"fixed-bottom"}). Note that using \code{"fixed-top"} or
\code{"fixed-bottom"} will cause the navbar to overlay your body content,
unless you add padding, e.g.: \code{tags$style(type="text/css", "body
  {padding-top: 70px;}")}}

\item{bg}{a CSS color to use for the navbar's background color.}

\item{inverse}{Either \code{TRUE} for a light text color or \code{FALSE} for a dark
text color. If \code{"auto"} (the default), the best contrast to \code{bg} is chosen.}

\item{collapsible}{\code{TRUE} to automatically collapse the navigation
elements into a menu when the width of the browser is less than 940 pixels
(useful for viewing on smaller touchscreen device)}

\item{placement}{placement of the nav items relative to the content.}
}
\description{
Render a collection of \code{\link[=nav]{nav()}} items into a container.
}
\examples{

library(shiny)

nav_items <- function(prefix) {
  list(
    nav("a", paste(prefix, ": tab a content")),
    nav("b", paste(prefix, ": tab b content")),
    nav_item(
      tags$a(icon("github"), "Shiny", href = "https://github.com/rstudio/shiny", target = "_blank")
    ),
    nav_spacer(),
    nav_menu(
      "Other links", align = "right",
      nav("c", paste(prefix, ": tab c content")),
      nav_item(
        tags$a(icon("r-project"), "RStudio", href = "https://rstudio.com", target = "_blank")
      )
    )
  )
}

if (interactive()) {
  shinyApp(
    page_navbar(
      title = "page_navbar()",
      bg = "#0062cc",
      !!!nav_items("page_navbar()"),
      footer = div(
        style = "width:80\%; margin: 0 auto",
        h4("navs_tab()"),
        navs_tab(!!!nav_items("navs_tab()")),
        h4("navs_pill()"),
        navs_pill(!!!nav_items("navs_pill()")),
        h4("navs_tab_card()"),
        navs_tab_card(!!!nav_items("navs_tab_card()")),
        h4("navs_pill_card()"),
        navs_pill_card(!!!nav_items("navs_pill_card()")),
        h4("navs_pill_list()"),
        navs_pill_list(!!!nav_items("navs_pill_list()"))
      )
    ),
    function(...) { }
  )
}
}
\seealso{
\code{\link[=nav]{nav()}}, \code{\link[=nav_select]{nav_select()}}.
}
