% Copyright 2019 Steven L. Scott. All Rights Reserved.
% Author: steve.the.bayesian@gmail.com (Steve Scott)

\name{plot.mbsts.prediction}
\title{Plot Multivariate Bsts Predictions}

\alias{plot.mbsts.prediction}

\description{Plot the posterior predictive distribution from an
  \code{\link{mbsts}} prediction object.}

\usage{
  \method{plot}{mbsts.prediction}(x,
     y = NULL,
     burn = 0,
     plot.original = TRUE,
     median.color = "blue",
     median.type = 1,
     median.width = 3,
     interval.quantiles = c(.025, .975),
     interval.color = "green",
     interval.type = 2,
     interval.width = 2,
     style = c("dynamic", "boxplot"),
     ylim = NULL,
     series.id = NULL,
     same.scale = TRUE,
     gap = 0,
     ...)
}

\arguments{

  \item{x}{An object of class \code{\link{bsts.prediction}}
    created by calling \code{predict} on a \code{\link{bsts}} object.}

  \item{y}{A dummy argument necessary to match the signature of the
    \code{\link{plot}} generic function.  This argument is unused.}

  \item{plot.original}{Logical or numeric.  If \code{TRUE} then the
      prediction is plotted after a time series plot of the original
      series.  If \code{FALSE}, the prediction fills the entire plot.
      If numeric, then it specifies the number of trailing observations
      of the original time series to plot in addition to the
      predictions.}

  \item{burn}{The number of observations you wish to discard as burn-in
       from the posterior predictive distribution.  This is in addition
       to the burn-in discarded using \code{\link{predict.bsts}}.}

  \item{median.color}{The color to use for the posterior median of the
    prediction.}

  \item{median.type}{The type of line (lty) to use for the posterior median
    of the prediction.}

  \item{median.width}{The width of line (lwd) to use for the posterior median
    of the prediction.}

  \item{interval.quantiles}{The lower and upper limits of the credible
    interval to be plotted.}

  \item{interval.color}{The color to use for the upper and lower limits
    of the 95\% credible interval for the prediction.}

  \item{interval.type}{The type of line (lty) to use for the upper and
    lower limits of the 95\% credible inerval for of the
    prediction.}

  \item{interval.width}{The width of line (lwd) to use for the upper and
    lower limits of the 95\% credible inerval for of the
    prediction.}

  \item{style}{Either "dynamic", for dynamic distribution plots, or
    "boxplot", for box plots.  Partial matching is allowed, so "dyn" or
    "box" would work, for example.}

  \item{ylim}{Limits on the vertical axis.}

  \item{series.id}{A factor, string, or integer used to indicate which
    of the multivariate series to plot.  If NULL then predictions for
    all series will be plotted.  If there are many series this can make
    the plot unreadable.}

  \item{same.scale}{ Logical.  If TRUE then all predictions are plotted
    with the same scale, and limits are drawn on the Y axis. If FALSE
    then each prediction is drawn to fill its plot region, and no tick
    marks are drawn on the y axis.  If ylim is specified then it is used
    for all plots, and same.scale is ignored.}

  \item{gap}{The amount of space to leave between plots, measured in
    lines of text.}

  \item{...}{Extra arguments to be passed to
    \code{\link[Boom]{PlotDynamicDistribution}}
    and \code{\link{lines}}.}
}

\details{ Plots the posterior predictive distribution described by
  \code{x} using a dynamic distribution plot generated by
  \code{\link[Boom]{PlotDynamicDistribution}}.  Overlays the
  posterior median and 95\% prediction limits for the predictive
  distribution.  }

\value{
  Returns NULL.
}
