% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verify.R
\name{verify_autoregression.PosteriorBSVAR}
\alias{verify_autoregression.PosteriorBSVAR}
\title{Verifies hypotheses involving autoregressive parameters}
\usage{
\method{verify_autoregression}{PosteriorBSVAR}(posterior, hypothesis)
}
\arguments{
\item{posterior}{the \code{posterior} element of the list from the estimation outcome}

\item{hypothesis}{an \code{NxK} matrix of the same dimension as the autoregressive 
matrix \eqn{A} with numeric values for the parameters to be verified,
in which case the values represent the joint hypothesis, and missing value \code{NA} 
for these parameters that are not tested}
}
\value{
An object of class \code{SDDRautoregression} that is a list of three components:

\code{logSDDR} a scalar with values of the logarithm of the Bayes factors for 
the autoregressive hypothesis for each of the shocks

\code{log_SDDR_se} an \code{N}-vector with estimation standard errors of the logarithm of 
the Bayes factors reported in output element \code{logSDDR} that are computed based on 30 random 
sub-samples of the log-ordinates of the marginal posterior and prior distributions.

\code{components} a list of three components for the computation of the Bayes factor
\describe{
  \item{log_denominator}{an \code{N}-vector with values of the logarithm of the Bayes factor denominators}
  \item{log_numerator}{an \code{N}-vector with values of the logarithm of the Bayes factor numerators}
  \item{log_numerator_s}{an \code{NxS} matrix of the log-full conditional posterior density ordinates computed to estimate the numerator}
  \item{log_denominator_s}{an \code{NxS} matrix of the log-full conditional posterior density ordinates computed to estimate the denominator}
  \item{se_components}{a \code{30}-vector containing the log-Bayes factors on the basis of which the standard errors are computed}
}
}
\description{
Computes the logarithm of Bayes factor for the joint hypothesis, 
\eqn{H_0}, possibly for many autoregressive parameters represented by argument 
\code{hypothesis} via Savage-Dickey Density Ration (SDDR).
The logarithm of Bayes factor for this hypothesis can be computed using the SDDR 
as the difference of logarithms of the marginal posterior distribution ordinate at the restriction 
less the marginal prior distribution ordinate at the same point:
\deqn{log p(H_0 | data) - log p(H_0)}
Therefore, a negative value of the difference is the evidence against 
hypothesis. The estimation of both elements of the difference requires 
numerical integration.
}
\examples{
# simple workflow
############################################################
# upload data
data(us_fiscal_lsuw)

# specify the model and set seed
specification  = specify_bsvar$new(us_fiscal_lsuw, p = 1)
set.seed(123)

# estimate the model
posterior      = estimate(specification, 10, thin = 1)

# verify autoregression
H0             = matrix(NA, ncol(us_fiscal_lsuw), ncol(us_fiscal_lsuw) + 1)
H0[1,3]        = 0        # a hypothesis of no Granger causality from gdp to ttr
sddr           = verify_autoregression(posterior, H0)

# workflow with the pipe |>
############################################################
set.seed(123)
us_fiscal_lsuw |>
  specify_bsvar$new(p = 1) |>
  estimate(S = 10, thin = 1) |> 
  verify_autoregression(hypothesis = H0) -> sddr

}
\references{
Woźniak, T., and Droumaguet, M., (2024) Bayesian Assessment of Identifying Restrictions for Heteroskedastic Structural VARs
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
