% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.PosteriorBSVARSV}
\alias{summary.PosteriorBSVARSV}
\title{Provides posterior summary of heteroskedastic Structural VAR estimation}
\usage{
\method{summary}{PosteriorBSVARSV}(object, ...)
}
\arguments{
\item{object}{an object of class PosteriorBSVARSV obtained using the
\code{estimate()} function applied to heteroskedastic Bayesian Structural VAR
model specification set by function \code{specify_bsvar_sv$new()} containing 
draws from the  posterior distribution of the parameters.}

\item{...}{additional arguments affecting the summary produced.}
}
\value{
A list reporting the posterior mean, standard deviations, as well as 5 and 95 
percentiles of the parameters: the structural matrix \eqn{B}, autoregressive 
parameters \eqn{A}, and hyper-parameters.
}
\description{
Provides posterior mean, standard deviations, as well as 5 and 95 
percentiles of the parameters: the structural matrix \eqn{B}, autoregressive 
parameters \eqn{A}, and hyper parameters.
}
\examples{
# upload data
data(us_fiscal_lsuw)

# specify the model and set seed
set.seed(123)
specification  = specify_bsvar_sv$new(us_fiscal_lsuw)

# run the burn-in
burn_in        = estimate(specification, 10)

# estimate the model
posterior      = estimate(burn_in, 20)
summary(posterior)

# workflow with the pipe |>
############################################################
set.seed(123)
us_fiscal_lsuw |>
  specify_bsvar_sv$new() |>
  estimate(S = 10) |> 
  estimate(S = 20) |> 
  summary()

}
\seealso{
\code{\link{estimate}}, \code{\link{specify_bsvar_sv}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
