% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/btergm.R
\docType{package}
\name{btergm-package}
\alias{btergm-package}
\title{Temporal Exponential Random Graph Models by Bootstrapped Pseudolikelihood}
\description{
Temporal Exponential Random Graph Models by Bootstrapped Pseudolikelihood.
}
\details{
Temporal Exponential Random Graph Models (TERGM) estimated by maximum
pseudolikelihood with bootstrapped confidence intervals, Markov Chain Monte
Carlo maximum likelihood, or Bayesian estimation. Goodness of fit assessment
for ERGMs, TERGMs, and SAOMs. Micro-level interpretation of ERGMs and TERGMs.

The \pkg{btergm} package implements TERGMs with MPLE and bootstrapped
confidence intervals (\code{\link{btergm}} function), MCMC MLE
(\code{\link{mtergm}} function), or Bayesian estimation (\code{\link{tbergm}}
function). Goodness of fit assessment for ERGMs, TERGMs, SAOMs, and dyadic
independence models is possible with the generic \code{\link{gof}} function
and its various methods defined here in the \pkg{btergm} package. New
networks can be simulated from TERGMs using the \code{\link{simulate.btergm}}
function. The package also implements micro-level interpretation for ERGMs
and TERGMs using the \code{\link{interpret}} function. Furthermore, the
package contains the \code{\link{chemnet}} and \code{\link{knecht}} (T)ERGM
datasets. To display citation information, type \code{citation("btergm")}.
}
\references{
Cranmer, Skyler J., Tobias Heinrich and Bruce A. Desmarais (2014):
Reciprocity and the Structural Determinants of the International Sanctions
Network. \emph{Social Networks} 36(1): 5-22.
\doi{10.1016/j.socnet.2013.01.001}.

Desmarais, Bruce A. and Skyler J. Cranmer (2012): Statistical Mechanics of
Networks: Estimation and Uncertainty. \emph{Physica A} 391: 1865--1876.
\doi{10.1016/j.physa.2011.10.018}.

Desmarais, Bruce A. and Skyler J. Cranmer (2010): Consistent Confidence
Intervals for Maximum Pseudolikelihood Estimators. \emph{Neural Information
Processing Systems 2010 Workshop on Computational Social Science and the
Wisdom of Crowds}.

Leifeld, Philip, Skyler J. Cranmer and Bruce A. Desmarais (2018): Temporal
Exponential Random Graph Models with btergm: Estimation and Bootstrap
Confidence Intervals. \emph{Journal of Statistical Software} 83(6): 1--36.
\doi{10.18637/jss.v083.i06}.
}
\author{
Philip Leifeld, Skyler J. Cranmer, Bruce A. Desmarais
}
